<?php

/**
 * i-doit
 *
 * Dashboard widget class
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.2
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_dashboard_widgets_stats extends isys_dashboard_widgets
{
    /**
     * Path and Filename of the configuration template.
     *
     * @var  string
     */
    protected $m_config_tpl_file = '';

    /**
     * Path and Filename of the template.
     *
     * @var  string
     */
    protected $m_tpl_file = '';

    /**
     * Returns a boolean value, if the current widget has an own configuration page.
     *
     * @return  boolean
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function has_configuration()
    {
        return true;
    }

    /**
     * Init method.
     *
     * @param   array $p_config
     *
     * @return  isys_dashboard_widgets_quicklaunch
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function init($p_config = [])
    {
        $this->m_tpl_file = __DIR__ . '/templates/stats.tpl';
        $this->m_config_tpl_file = __DIR__ . '/templates/config.tpl';

        return parent::init($p_config);
    }

    /**
     * Method for loading the widget configuration.
     *
     * @param   array   $p_row The current widget row from "isys_widgets".
     * @param   integer $p_id  The ID from "isys_widgets_config".
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function load_configuration(array $p_row, $p_id)
    {
        $l_dao = isys_application::instance()->container->get('cmdb_dao');

        if (!is_array($this->m_config['obj_types'])) {
            $this->m_config['obj_types'] = [];
        }

        $l_obj_type_data = [];
        $l_obj_types = $l_dao->get_object_type();

        foreach ($l_obj_types as $l_obj_type) {
            $l_obj_type_data[] = [
                'id'  => $l_obj_type['isys_obj_type__const'],
                'val' => $l_obj_type['LC_isys_obj_type__title'],
                'sel' => in_array($l_obj_type['isys_obj_type__const'], $this->m_config['obj_types'])
            ];
        }

        $l_rules = [
            'title'         => $this->m_config['title'],
            'legend'        => $this->m_config['legend'],
            'obj_types'     => serialize($l_obj_type_data),
            'selected_type' => $this->m_config['chart_type'],
            'chart_types'   => serialize([
                'Pie'            => 'LC__WIDGET__STATS__CONFIG_TYPE__PIE',
                'Donut'          => 'LC__WIDGET__STATS__CONFIG_TYPE__DONUT',
                'Bar'            => 'LC__WIDGET__STATS__CONFIG_TYPE__BAR',
                'StackedBar'     => 'LC__WIDGET__STATS__CONFIG_TYPE__STACKED_BAR',
                'SideBar'        => 'LC__WIDGET__STATS__CONFIG_TYPE__SIDE_BAR',
                'SideStackedBar' => 'LC__WIDGET__STATS__CONFIG_TYPE__SIDE_STACKED_BAR',
            ]),
        ];

        return $this->m_tpl->activate_editmode()
            ->assign('title', isys_application::instance()->container->get('language')
                ->get('LC__WIDGET__STATS__CONFIG'))
            ->assign('rules', $l_rules)
            ->fetch($this->m_config_tpl_file);
    }

    /**
     * Render method.
     *
     * @param   string $p_unique_id
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function render($p_unique_id)
    {
        $l_dao = isys_application::instance()->container->get('cmdb_dao');

        $l_obj_type_config = [];
        $l_obj_types = $l_dao->get_object_type(null, $this->m_config['obj_types']);

        foreach ($l_obj_types as $l_obj_type) {
            $l_sql = 'SELECT COUNT(1) AS cnt
                FROM isys_obj
				WHERE isys_obj__isys_obj_type__id = ' . $l_dao->convert_sql_id($l_obj_type['isys_obj_type__id']) . '
				AND isys_obj__status = ' . $l_dao->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';

            $l_cnt_row = $l_dao->retrieve($l_sql)->get_row();

            $l_obj_type_config[] = [
                'id'    => $l_obj_type['isys_obj_type__id'],
                'title' => $l_obj_type['LC_isys_obj_type__title'],
                'color' => isys_helper_color::unifyHexColor($l_obj_type['isys_obj_type__color']),
                'count' => (int)($l_cnt_row['cnt'] ?? 0)
            ];
        }

        return $this->m_tpl->assign('legend', !empty($this->m_config['legend']))
            ->assign('title', $this->m_config['title'])
            ->assign('chart_type', str_replace('Mini.', '', $this->m_config['chart_type']))
            ->assign('unique_id', $p_unique_id)
            ->assign('object_types', $l_obj_type_config)
            ->fetch($this->m_tpl_file);
    }
}
