<?php

namespace idoit\Module\Qrcode\Controller;

use isys_application;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * QR-Code controller.
 *
 * @package   Modules
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class QrCodeController
{
    /**
     * @param Request $request
     * @param int     $objectId
     *
     * @return Response
     * @throws \SmartyException
     */
    public function getModal(Request $request, int $objectId): Response
    {
        $routeGenerator = isys_application::instance()->container->get('route_generator');
        $template = isys_application::instance()->container->get('template');

        $data = (new \idoit\Module\Qrcode\Component\QrCode())->getData($objectId);

        $content = $template
            ->assign('wwwDir', isys_application::instance()->www_path)
            ->assign('qrCodeUrl', $routeGenerator->generate('qrcode.image.object', ['objectId' => $objectId]))
            ->assign('description', $data['description'])
            ->assign('logoUrl', $data['logo'])
            ->fetch(\isys_module_qrcode::getPath() . 'templates/modal/qr-code.tpl');

        return new Response($content);
    }
}
