<?php

/**
 * i-doit Report Manager View
 *
 * @package     i-doit
 * @subpackage  Reports
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @copyright   Copyright 2011 - synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_report_view_layer3_nets extends isys_report_view
{
    /**
     * @return string
     */
    public static function name()
    {
        return 'LC__REPORT__VIEW__LAYER3_NETS__TITLE';
    }

    /**
     * @return string
     */
    public static function description()
    {
        return 'LC__REPORT__VIEW__LAYER3_NETS__DESCRIPTION';
    }

    /**
     * @return string
     */
    public function template()
    {
        return __DIR__ . '/view_layer3_nets.tpl';
    }

    /**
     * @return string
     */
    public static function viewtype()
    {
        return 'LC__CMDB__OBJTYPE__RELATION';
    }

    /**
     * @todo  Better use (one?) "report specific" query than relying on multiple DAOs and their returned values
     */
    public function start()
    {
        // Preparing some variables.
        $rawData = [];
        $preparedFrontendData = [];

        // Initializing the DAO's.
        $l_obj_dao = isys_cmdb_dao::instance($this->database);
        $l_l3_dao = isys_cmdb_dao_category_s_net::instance($this->database);
        $l_port_dao = isys_cmdb_dao_category_g_network_port::instance($this->database);
        $hostaddressDao = isys_cmdb_dao_category_g_ip::instance($this->database);

        $empty = isys_tenantsettings::get('gui.empty_value', '-');

        // At first we search all objects of the type "layer2 net".
        $l_obj_res = $l_obj_dao->get_objects_by_cats_id(defined_or_default('C__CATS__NET'));

        // And now the fun begins...
        while ($l_obj_row = $l_obj_res->get_row()) {
            if (empty($l_obj_row['isys_obj__title'])) {
                $l_obj_row['isys_obj__title'] = '(' . $this->language->get('LC__UNIVERSAL__NO_TITLE') . ')';
            }

            $l_l3_link = '<a href="?' . C__CMDB__GET__OBJECT . '=' . $l_obj_row['isys_obj__id'] . '">' . $l_obj_row['isys_obj__title'] . '</a>';

            // We need this for L3 nets without assigned objects.
            if (!isset($rawData[$l_l3_link])) {
                $rawData[$l_l3_link] = [];
            }

            $l_server_res = $l_l3_dao->get_assigned_hosts($l_obj_row['isys_obj__id']);

            // Here we retrieve all server, which have assigned the layer3 net of this iteration.
            while ($l_server_row = $l_server_res->get_row()) {
                if (empty($l_server_row['isys_obj__title'])) {
                    $l_server_row['isys_obj__title'] = '(' . $this->language->get('LC__UNIVERSAL__NO_TITLE') . ')';
                }

                $l_server_link = '<a href="?' . C__CMDB__GET__OBJECT . '=' . $l_server_row['isys_obj__id'] . '">' . $l_server_row['isys_obj__title'] . '</a>';

                // We need this for L3 nets without ports.
                if (!isset($rawData[$l_l3_link][$l_server_link])) {
                    $rawData[$l_l3_link][$l_server_link] = [];
                }

                // For this server, we fetch all ports.
                $l_port_res = $l_port_dao->get_data(null, $l_server_row['isys_obj__id']);

                while ($l_port_row = $l_port_res->get_row()) {

                    // Get hostaddress data.
                    // isys_catg_ip_list__isys_catg_port_list__id = $l_port_row['isys_catg_port_list__id']
                    $hostaddressCondition = ' AND isys_catg_ip_list__isys_catg_port_list__id = ' . $l_obj_dao->convert_sql_id($l_port_row['isys_catg_port_list__id']) . ' ';
                    $hostaddressRow = $hostaddressDao
                        ->get_data(null, null, $hostaddressCondition, null, C__RECORD_STATUS__NORMAL)
                        ->get_row();

                    $l_ip_address = $hostaddressRow['isys_cats_net_ip_addresses_list__title'];
                    $l_ip_port = $hostaddressRow['isys_catg_port_list__title'];

                    // For each port we can now select the assigned layer2 nets.
                    $l_l2_nets = $l_port_dao->get_attached_layer2_net_as_array($l_port_row['isys_catg_port_list__id']);

                    if (is_array($l_l2_nets) && count($l_l2_nets)) {
                        foreach ($l_l2_nets as $l_l2_net_id) {
                            $rawData[$l_l3_link][$l_server_link][$l_ip_address][$l_ip_port] = '<a href="?' . C__CMDB__GET__OBJECT . '=' . $l_l2_net_id . '">' . $l_obj_dao->get_obj_name_by_id_as_string($l_l2_net_id) . '</a>';
                        }
                    } else {
                        $rawData[$l_l3_link][$l_server_link][$l_ip_address][$l_ip_port] = $empty;
                    }
                }
            }
        }

        // To easily display the data we have to alter the array structure.
        foreach ($rawData as $l_key => $l_item) {
            if (!is_array($l_item) || empty($l_item)) {
                $preparedFrontendData[] = [$l_key];
                continue;
            }

            foreach ($l_item as $l_key2 => $l_item2) {
                if (!is_array($l_item2) || empty($l_item2)) {
                    $preparedFrontendData[] = [$l_key, $l_key2];
                    continue;
                }

                foreach ($l_item2 as $l_key3 => $l_item3) {
                    if (!is_array($l_item3) || empty($l_item3)) {
                        $preparedFrontendData[] = [$l_key, $l_key2, $l_key3];
                        continue;
                    }

                    foreach ($l_item3 as $l_key4 => $l_item4) {
                        $preparedFrontendData[] = [$l_key, $l_key2, $l_key3, $l_key4, $l_item4];
                    }
                }
            }
        }

        // Finally assign the data to the template.
        $this->template->assign('data', $preparedFrontendData);
    }
}
