[{isys_group name="tom.popup.tfa"}]
<div id="tfa-activate-popup">
    <div class="modal-header">
        <h1>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__ACTIVATE_TFA"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="modal-content p20">
        <h2>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__ACTIVATE_INFO"}]</h2>

        <p class="mt20 mb20">
            [{isys type="lang" ident="LC__USER_SETTINGS__TFA__HOWTO"}]
        </p>

        <div class="display-flex flex-container-row align-items-center" style="min-width: 100%">
            <img src="[{$tfa_qrcode}]" width="150" height="150" class="display-block" alt="qr-code" />
            <div class="display-flex align-items-center">
                <strong class="pl10 pr20">[{isys type="lang" ident="LC__USER_SETTINGS__TFA__ACTION_OR"}]</strong>

                <div>
                    <input type="password" value="[{$tfa_secret}]" class="input" style="width:200px;" readonly="readonly" id="tfa_secret_input" />
                    <button id="tfa_copy_secret" type="button" class="btn">[{isys type="lang" ident="LC__USER_SETTINGS__TFA__COPY_SECRET"}]</button>
                    <label class="pt10 display-block">
                        <input type="checkbox" id="tfa_reveal_secret" class="mr5" /><span>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__REVEAL_SECRET"}]</span>
                    </label>
                </div>
            </div>
        </div>

        <hr class="mt20 mb20" />

        <p class="mb20">
            [{isys type="lang" ident="LC__USER_SETTINGS__TFA__ACTIVATE_CONFIRM"}]
        </p>

        <div class="input-group input-size-block">
            [{isys type="f_text" name="tfa_code"}]
            <button type="button" class="btn save-button ml5" id="tfa_verify">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__VERIFY"}]</span>
            </button>
        </div>

    </div>

    <div class="modal-footer">
        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function() {
        const $popup = $('tfa-activate-popup');
        const tfaSecret = '[{$tfa_secret}]';
        const $copySecretButton = $('tfa_copy_secret');
        const $revealSecretButton = $('tfa_reveal_secret');
        const $secretInput = $('tfa_secret_input');
        const $verifyButton = $('tfa_verify');

        $popup.select('.popup-closer').invoke('on', 'click', function() {
            Modal.close($popup.up('.modal'));
        });

        preventAccidentalFormSubmit($popup);

        if (tfaSecret) {
            if (!navigator.clipboard) {
                $copySecretButton.hide();
            }

            $copySecretButton.on('click', function () {
                if (navigator.clipboard) {
                    navigator.clipboard.writeText(tfaSecret);
                    idoit.Notify.success('[{isys type="lang" ident="LC__USER_SETTINGS__TFA__SECRET_COPIED"}]', { life: 5 });
                    return;
                }

                idoit.Notify.error('[{isys type="lang" ident="LC__USER_SETTINGS__TFA__SECRET_COPY_ERROR"}]');
            });

            $revealSecretButton.on('change', function () {
                if ($secretInput.readAttribute('type') !== 'text') {
                    $secretInput.writeAttribute('type', 'text');
                } else {
                    $secretInput.writeAttribute('type', 'password');
                }
            });
        }

        $verifyButton.on('click', function() {
            $verifyButton.down('img')
                .addClassName('animation-rotate')
                .writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

            new Ajax.Request(idoit.Router.getRoute('tfa.activate'), {
                method:     "post",
                parameters: {
                    code: $F('tfa_code')
                },
                onComplete: function (xhr) {
                    $verifyButton.down('img')
                        .removeClassName('animation-rotate')
                        .writeAttribute('src', window.dir_images + 'axialis/basic/symbol-ok.svg');

                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (!json.success) {
                        idoit.Notify.error(json.message, { life: 5 });
                        return;
                    }

                    document.location.reload();
                }
            });
        });
    })();
</script>
[{/isys_group}]
