<?php

namespace idoit\Component\Provider;

use isys_application as Application;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * i-doit Container Aware Trait
 *
 * @package     i-doit
 * @subpackage  Component
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
trait DiInjectable
{
    use ContainerAwareTrait;

    /**
     * @param ContainerInterface $container
     *
     * @return mixed
     */
    public function setDi(ContainerInterface $container): mixed
    {
        $this->setContainer($container);

        return $this;
    }

    /**
     * @return ContainerInterface
     */
    public function getDi(): ContainerInterface
    {
        if (!$this->container) {
            $this->setContainer(Application::instance()->container);
        }

        return $this->container;
    }
}
