[{isys type="f_text" name="csv_filename" p_bInvisible=true p_bInfoIconSpacer=0}]

<div id="import-csv" class="border-bottom">
    <div class="bg-neutral-200 border-bottom p5 display-flex align-items-center">
        <h2 class="mr-auto">[{isys type="lang" ident="LC__MASS_CHANGE__OPTIONS"}]</h2>

        [{if $isAllowedToViewProfiles}]
        [{isys type="f_label" name="profile_sbox" ident="LC__MODULE__IMPORT__CSV__PROFILES"}]
        <div class="ml5 mr20">
            [{isys type="f_dialog" name="profile_sbox" p_strClass="input-small" disableInputGroup=true p_bInfoIconSpacer=0}]
        </div>

        <button type="button" class="btn" id="import-csv-load-profile">
            <img src="[{$dir_images}]axialis/basic/symbol-download.svg" alt=""><span>[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__PROFILE_LOAD"}]</span>
        </button>

        [{if $isAllowedToDeleteProfiles}]
        <button type="button" class="btn ml5" id="import-csv-delete-profile">
            <img src="[{$dir_images}]axialis/industry-manufacturing/waste-bin.svg" alt=""><span>[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__PROFILE_DELETE"}]</span>
        </button>
        [{/if}]
        [{/if}]
    </div>

    <table id="import-csv-options" class="contentTable mt5 mb5">
        <tr>
            <td class="key">
                [{isys type="f_label" name="object_type" ident="LC__UNIVERSAL__GLOBAL_OBJECTTYPE"}]
                <img src="[{$dir_images}]axialis/basic/button-help.svg" alt="help" data-tooltip="1" title="[{isys type='lang' ident='LC__UNIVERSAL__GLOBAL_OBJECTTYPE_INFO'}]" class="vam mouse-help" />
            </td>
            <td class="value">
                [{isys type="f_dialog" name="object_type" p_strClass="input-small" chosen=true}]
            </td>
        </tr>
        <tr>
            <td class="key">
                [{isys type="lang" name="csv_separator" ident="LC__UNIVERSAL__SEPARATOR"}]
                <img title="[{isys type="lang" ident="LC__UNIVERSAL__CSV_SEPARATOR_INFO"}]" alt="help" data-tooltip="1" src="[{$dir_images}]axialis/basic/button-help.svg" class="vam mouse-help" />
            </td>
            <td class="value">
                [{isys type="f_text" name="csv_separator" p_strValue=";" p_strStyle="width:30px;" disableInputGroup=true}] <code id="csv-preview" class="ml10 box p5">"Wert";"Wert2";"..."</code>
            </td>
        </tr>
        <tr>
            <td class="key">
                [{isys type="f_label" name="csv_header" ident="LC__UNIVERSAL__HEADER"}]
                <img title="[{isys type='lang' ident='LC__UNIVERSAL__CSV_HEADER_INFO'}]" alt="help" data-tooltip="1" src="[{$dir_images}]axialis/basic/button-help.svg" class="vam mouse-help" />
            </td>
            <td class="value">
                [{isys type="checkbox" name="csv_header" p_bChecked=true p_strClass="vam"}]
            </td>
        </tr>
        <tr>
            <td class="key">
                [{isys type="f_label" name="csv_default_template" ident="LC__MODULE__IMPORT__CSV__CONSIDER_DEFAULT_TEMPLATE"}]
                <img title="[{isys type='lang' ident='LC__MODULE__IMPORT__CSV__CONSIDER_DEFAULT_TEMPLATE_INFO'}]" alt="help" data-tooltip="1" src="[{$dir_images}]axialis/basic/button-help.svg" class="vam mouse-help" />
            </td>
            <td class="value">
                [{isys type="checkbox" name="csv_default_template" p_bChecked=true p_strClass="vam"}]
            </td>
        </tr>
        <tr>
            <td></td>
            <td class="pl20 pt10">
                [{isys type="f_button" name="csv_import_process_options" icon="`$dir_images`axialis/basic/gear.svg" p_strValue="LC__MODULE__IMPORT__CSV__PROCESS_OPTIONS"}]
                <img id="import-csv-options-notice" src="[{$dir_images}]axialis/basic/warning.svg" class="ml10 hide vam" title="[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__OPTION_CHANGE_NOTICE"}]" />
            </td>
        </tr>
        <tr>
            <td class="category-spacer" colspan="2"><hr /></td>
        </tr>
        <tr>
            <td class="key">
                <span>[{isys type='lang' ident='LC__UNIVERSAL__SINGLEVALUE_OBJECTS'}]</span>
                <img title="[{isys type='lang' ident='LC__UNIVERSAL__SINGLEVALUE_OBJECTS_INFO'}]" alt="help" data-tooltip="1" src="[{$dir_images}]axialis/basic/button-help.svg" class="vam mouse-help" />
            </td>
            <td class="value pl20">
                <label class="mr10"><input type="radio" name="singlevalue_overwrite_empty_values" id="singlevalue_overwrite_yes" value="1" /> [{isys type='lang' ident='LC__UNIVERSAL__YES'}]</label>
                <label><input type="radio" name="singlevalue_overwrite_empty_values" id="singlevalue_overwrite_no" value="0" checked="checked" /> [{isys type='lang' ident='LC__UNIVERSAL__NO'}]</label>
            </td>
        </tr>
        <tr>
            <td class="key">
                <span>[{isys type='lang' ident='LC__UNIVERSAL__MULTIVALUE_OBJECTS'}]</span>
                <img title="[{isys type='lang' ident='LC__UNIVERSAL__MULTIVALUE_OBJECTS_INFO'}]" alt="help" data-tooltip="1" src="[{$dir_images}]axialis/basic/button-help.svg" class="vam mouse-help" />
            </td>
            <td class="value pl20">
                <label class="mr10"><input type="radio" name="multivalue" id="multivalue_column" value="column" checked="checked" /> [{isys type='lang' ident='LC__UNIVERSAL__COLUMN'}]</label>
                <label class="mr10"><input type="radio" name="multivalue" id="multivalue_row" value="row" /> [{isys type='lang' ident='LC__UNIVERSAL__ROW'}]</label>
                <label><input type="radio" name="multivalue" id="multivalue_comma" value="comma" /> [{isys type='lang' ident='LC__UNIVERSAL__COMMA_SEPARATED'}]</label>
            </td>
        </tr>
        <tr>
            <td class="key vat">
                <span>[{isys type="lang" ident="LC__MASS_CHANGE__HANDLING_MULTI-VALUED_CATEGORIES"}]</span>
            </td>
            <td class="value pl20">
                <label class="display-block mb5">
                    <input type="radio" class="mr5" value="[{$multivalue_modes.untouched}]" name="multivalue_mode" checked="checked" />[{isys type='lang' ident='LC__CSV__KEEP_CATEGORY_ENTRIES_UNTOUCHED'}]
                </label>
                <label class="display-block mb5">
                    <input type="radio" class="mr5" value="[{$multivalue_modes.add}]" name="multivalue_mode" />[{isys type='lang' ident='LC__CSV__ADD_CATEGORY_ENTRIES'}]
                </label>
                <label class="display-block mb5">
                    <input type="radio" class="mr5" value="[{$multivalue_modes.overwrite}]" name="multivalue_mode" />[{isys type='lang' ident='LC__CSV__DELETE_BEFORE_ADD_CATEGORY_ENTRIES'}]
                </label>
            </td>
        </tr>
    </table>

    <div id="import-csv-assignment">
        <div id="import-csv-assignment-modal" class="opacity-50"></div>

        <h3 class="p5 pt10 pb10 bg-neutral-200 border-top border-bottom">[{isys type="lang" ident="LC__MODULE__JDISC__PROFILES__OBJECT_MATCHING_PROFILES"}]</h3>

        <div class="m10">
            [{if $matcher}]
                <select id="object_matcher_profiles" class="input input-mini mb5 mr10">
                    <option value="-1">-</option>
                    [{foreach $matcher as $key => $match}]
                        <option value="[{$key}]">[{$match}]</option>
                    [{/foreach}]
                </select>
            [{/if}]

            <button type="button" id="import-csv-add-identificator" class="btn mb5 mr10">
                <img src="[{$dir_images}]axialis/basic/symbol-add.svg" alt="" /><span>[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__PROFILE_ADD_IDENTIFICATIONFIELD"}]</span>
            </button>

            <img title="[{isys type='lang' ident='LC__MODULE__IMPORT__CSV__IDENTIFICATION_DESCRIPTION'}]" alt="help" data-tooltip="1" src="[{$dir_images}]axialis/basic/button-help.svg" class="mouse-help" />

            <div id="identificators_hidden" class="hide">
                <div class="mt5">
                    <!-- Remove the ID's, because this HTML will be cloned n-times -->
                    [{isys type="f_dialog" id="" name="csv_ident[]" p_strClass="input-small mr5" p_bInfoIconSpacer=0 p_bDbFieldNN=true disableInputGroup=true}]
                    [{isys type="f_dialog" id="" name="identificator[]" p_strClass="input-small mr5" p_bInfoIconSpacer=0 p_bDbFieldNN=true disableInputGroup=true}]

                    <button type="button" class="btn">
                        <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__REMOVE"}]</span>
                    </button>
                </div>
            </div>

            <div id="identificators" style="display:none;">
                <ul class="list-style-none m0">
                    <li style="display: inline; margin-right: 193px;">[{isys type="lang" ident="LC__UNIVERSAL__CSV_HEADER"}]</li>
                    <li style="display: inline;">[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__CATEGORY_ATTRIBUTES"}]</li>
                </ul>
            </div>

            <div id="identificator_min_count_container" class="hide mt10">
                [{isys type="f_count" name="identificator_min_count" p_strClass="input-mini" inputGroupMarginClass="" p_onChange="if (\$F('identificator_min_count') < 1) {\$('identificator_min_count').setValue(1);} if (\$F('identificator_min_count') > \$('identificators').select('div.mt5').length) {\$('identificator_min_count').setValue(\$('identificators').select('div.mt5').length);}"}]
                <label for="identificator_min_count" class="ml5">[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__IDENTIFICATION_COUNT_LABEL"}]</label>
                <br class="cb" />
            </div>
        </div>

        <h3 class="p5 pt10 pb10 bg-neutral-200 border-top border-bottom">[{isys type="lang" ident="LC__UNIVERSAL__ASSIGNMENT"}]</h3>

        <table cellspacing="0" cellpadding="0" class="listing" id="csv_assignment_table">
            <colgroup>
                <col width="25%" />
                <col width="25%" />
                <col width="50%" />
            </colgroup>
            <thead>
            <tr>
                <th>[{isys type='lang' ident='LC__UNIVERSAL__CSV_HEADER'}]</th>
                <th class="text-neutral-400">[{isys type='lang' ident='LC__UNIVERSAL__FIRST_LINE'}]</th>
                <th>[{isys type='lang' ident='LC__UNIVERSAL__ASSIGNMENT'}]</th>
            </tr>
            </thead>
            <tbody>

            </tbody>
        </table>

        <div class="m10">
            <div class="fr right" style="min-width: 30%;">
                <label class="display-block mb5">
                    [{isys type="lang" ident="LC__MODULE__IMPORT__CSV__LOGGING__SIMPLE"}]
                    <input type="radio" name="csv-log-detail" class="ml5" value="simple" checked="checked" />
                </label>
                <label class="display-block mb5">
                    [{isys type="lang" ident="LC__MODULE__IMPORT__CSV__LOGGING__NORMAL"}]
                    <input type="radio" name="csv-log-detail" class="ml5" value="normal" />
                </label>
                <label class="display-block">
                    [{isys type="lang" ident="LC__MODULE__IMPORT__CSV__LOGGING__ALL"}]
                    <input type="radio" name="csv-log-detail" class="ml5" value="all" />
                </label>

                <div class="mt20">
                    <label class="display-block">
                        <span>[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__ROW_OFFSET"}]</span>
                        <input type="text" class="input ml20" name="csv-offset" id="csv-offset" value="0" style="width: 40px" />
                    </label>
                    <label class="display-block mt5">
                        <span>[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__ROW_LIMIT"}]</span>
                        <input type="text" class="input ml20" name="csv-limit" id="csv-limit" value="[{$csvImportLimit}]" style="width: 40px" />
                    </label>
                </div>

                <div class="mt20">
                    <button class="btn text-bold" type="button" id="import-start-button">
                        <img src="[{$dir_images}]axialis/basic/gear.svg" alt="" /><span>[{isys type='lang' ident='LC__UNIVERSAL__IMPORT'}]</span>
                    </button>

                    <button class="btn ml10" type="button" id="import-csv-stop-import" disabled>
                        <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt=""><span>[{isys type="lang" ident="LC__UNIVERSAL__STOP"}]</span>
                    </button>

                    <div class="progress mt5">
                        <div id="csv-import-progress-bar" class="progress-bar" style="width:0; background-color:transparent; transition: all 150ms;"></div>
                    </div>
                </div>
            </div>

            [{if $isAllowedToCreateProfiles || $isAllowedToEditProfiles}]
            <div class="mb10">
                <h3 class="mb5">[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__PROFILE_SAVE_AS"}]</h3>

                <input type="text" id="csv-profile-title" class="input input-small" placeholder="[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__PROFILE_TITLE"}]" />
                <button type="button" id="import-csv-save-profile" class="btn">
                    <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt=""><span>[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__PROFILE_SAVE"}]</span>
                </button>
            </div>
            [{/if}]

            <br class="cb" />

        </div>

        <div id="import-result-container" style="width:auto;"></div>
    </div>
</div>

<style type="text/css">
    #import-csv-assignment {
        position: relative;
    }

    #import-csv-assignment-modal {
        position: absolute;
        width: 100%;
        height: 100%;
        background: #fff;
        z-index: 100;
    }

    #csv_assignment_table {
        table-layout: fixed;
    }

    #csv_assignment_table .overflowable {
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
    }

    #csv_assignment_table .attribute-box {
        box-sizing: border-box;
        width: 500px;
        min-height: 32px;
        padding: 2px 5px;
        vertical-align: middle;
        border: 1px dashed #ccc;
        background: #fff;
        display: flex;
        align-items: center;
    }

    #import-csv tr.active {
        background: #eee;
    }

    #import-csv .object-type-assignment {
        width: 560px;
    }

    #import-csv .object-type-assignment > div {
        clear: both;
        min-height: 32px;
        margin: 5px 0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }
</style>

<script>
    (function () {
        var $input_submit_form     = $('submit_isys_form'),
            $select_profiles       = $('profile_sbox'),
            $button_profile_loader = $('import-csv-load-profile');

        if (!$select_profiles) {
            $select_profiles = new Element('select').update(new Element('option', {value:0}));
        }

        if (!$button_profile_loader) {
            $button_profile_loader = new Element('button', {type:'button'});
        }

        if ($input_submit_form) {
            $input_submit_form.disable();
        }

        $select_profiles.on('profiles:preselect', function (ev) {
            if (!!ev.memo.selectLatest) {
                $select_profiles.setValue($select_profiles.down('option:last').readAttribute('value'));
            } else if (ev.memo.preselection > 0) {
                $select_profiles.setValue(ev.memo.preselection);
            }

            if (!!ev.memo.simulateClick) {
                $button_profile_loader.simulate('click');
            }
        });
    })();

    idoit.Translate.set('LC__MODULE__IMPORT__CSV__PRESELECTION_MATCHED', '[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__PRESELECTION_MATCHED"}]');
    idoit.Translate.set('LC__MODULE__IMPORT__CSV__PRESELECTION_ERROR', '[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__PRESELECTION_ERROR"}]');

    [{include file='modules/import/csv_mapping.js'}]
    [{include file='modules/import/csv_import.js'}]
</script>
