<?php

namespace idoit\Module\Analytics\Component\Tree;

use isys_application;

/**
 * i-doit
 *
 * Formatter class for the IT-Service algorithm.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4
 */
class Formatter
{
    /**
     * Options array.
     *
     * @var array
     */
    private $options = [];

    /**
     * Method for formatting the single object nodes.
     *
     * @param  integer $objectID
     * @param  boolean $doubling
     * @param  array   $rowData
     *
     * @return \isys_tree_node_explorer
     * @throws \isys_exception_database
     * @author Leonard Fischer <lfischer@i-doit.com>
     */
    public function format($objectID, $doubling = false, $rowData = [])
    {
        $db = \isys_application::instance()->container->get('database');
        $dao = \isys_cmdb_dao::instance($db);

        $objectData = $dao->retrieve('SELECT * FROM isys_obj
			LEFT JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
			LEFT JOIN isys_cmdb_status ON isys_cmdb_status__id = isys_obj__isys_cmdb_status__id
			WHERE isys_obj__id = ' . $dao->convert_sql_id($objectID) . ';')
            ->get_row();

        $options = array_replace_recursive($this->options, [
                'id'                => $objectID,
                'is_simulation_obj' => in_array($objectID, \isys_analytics_dao::instance($db)->get_simulation_objects())
            ]);

        if (isset($rowData['isys_catg_relation_list__isys_relation_type__id'])) {
            $relationData = [
                'title'           => $dao->obj_get_title_by_id_as_string($rowData['isys_catg_relation_list__isys_obj__id']),
                'id'              => $rowData['isys_catg_relation_list__isys_obj__id'],
                'type'            => $rowData['isys_catg_relation_list__isys_relation_type__id'],
                'master'          => $rowData['isys_catg_relation_list__isys_obj__id__master'],
                'slave'           => $rowData['isys_catg_relation_list__isys_obj__id__slave'],
                'its'             => $rowData['isys_catg_relation_list__isys_obj__id__itservice'],
                'weighting'       => $rowData['isys_catg_relation_list__isys_weighting__id'],
                'cluster_members' => count(\isys_cmdb_dao_list_catg_cluster_members::instance($db)
                    ->get_result(null, $rowData['isys_catg_relation_list__isys_obj__id__slave']))
            ];
        } else {
            $relationData = [];
        }

        $objectCategory = $itServiceName = '';

        if ($objectData['isys_obj__isys_obj_type__id'] == C__OBJTYPE__IT_SERVICE) {
            $row = \isys_cmdb_dao_category_g_its_type::instance($db)
                ->get_data(null, $objectID)
                ->get_row();

            if ($row && !empty($row['isys_its_type__title'])) {
                $objectCategory = '(' . _L('LC__CMDB__CATG__ITS_TYPE') . ': ' . _L($row['isys_its_type__title']) . ')';
                $itServiceName = _L($row['isys_its_type__title']);
            }
        }

        // Find out if the current object is part of a parallel relation.
        $sql = 'SELECT isys_cats_relpool_list__isys_obj__id
			FROM isys_cats_relpool_list_2_isys_obj AS rel
			LEFT JOIN isys_cats_relpool_list AS relpool ON relpool.isys_cats_relpool_list__id = rel.isys_cats_relpool_list__id
			WHERE isys_obj__id = ' . $dao->convert_sql_id($objectID) . ';';

        $parallelRelationResult = $dao->retrieve($sql);
        $parallelRelations = null;

        if (count($parallelRelationResult)) {
            $parallelRelations = [];

            while ($parallelRelationRow = $parallelRelationResult->get_row()) {
                $parallelRelations[] = $parallelRelationRow['isys_cats_relpool_list__isys_obj__id'];
            }
        }

        $icon = isys_application::instance()->www_path . 'images/icons/silk/page_white.png';

        if (!empty($objectData['isys_obj_type__icon'])) {
            if (strpos($objectData['isys_obj_type__icon'], '/') !== false) {
                $icon = $objectData['isys_obj_type__icon'];
            } else {
                $icon = isys_application::instance()->www_path . 'images/tree/' . $objectData['isys_obj_type__icon'];
            }
        }

        return new \isys_tree_node_explorer([
                'id'       => $options['id'],
                'name'     => trim($objectData['isys_obj__title']),
                'children' => [],
                'data'     => [
                    C__CMDB__GET__OBJECT    => $objectID,
                    'objTypeID'             => $objectData['isys_obj__isys_obj_type__id'],
                    'icon'                  => $icon,
                    'image'                 => isys_application::instance()->www_path . 'images/objecttypes/' . ($objectData['isys_obj_type__obj_img_name'] ?: 'empty.png'),
                    'objectType'            => _L($objectData['isys_obj_type__title']),
                    'relation'              => $relationData,
                    'subNodes'              => $options['children_count'],
                    'color'                 => isset($objectData['isys_obj_type__color']) ? '#' . $objectData['isys_obj_type__color'] : false,
                    'statusColor'           => $objectData['isys_cmdb_status__color'],
                    'cmdb_status'           => _L($objectData['isys_cmdb_status__title']),
                    'objectCategory'        => $objectCategory,
                    'itserviceType'         => $itServiceName,
                    'is_simulation_obj'     => $options['is_simulation_obj'],
                    'parallel_relation_obj' => $parallelRelations
                ]
            ]);
    }
}
