<?php

/**
 * i-doit
 *
 * Tree visitor class.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Dennis Stücken <dstuecken@i-doit.org>
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */
class isys_tree_visitor_level implements isys_tree_visitor_interface
{

    protected $m_filter = [];

    /**
     *
     * @param   isys_tree|isys_tree_node $p_node
     *
     * @return  mixed
     */
    public function visit(isys_tree $p_node)
    {
        $l_return = [];

        if ($p_node instanceof isys_tree_node && isset($this->m_filter['level']) && $this->m_filter['level'] > 0 && $p_node->level() > $this->m_filter['level'] + 1) {
            // Level cut off.
            $l_return[] = $p_node->remove();
        }

        // Iterate through childs and call accept as well.
        foreach ($p_node->get_childs() as $l_child) {
            $l_return = array_merge($l_return, $l_child->accept($this));
        }

        return $l_return;
    }

    /**
     * Construct visitor with special filter. Filter structure:
     * array(
     *   'all-but-it-services' => bool,
     *   'all-but-impact-path-objects' => bool,
     *   'level' => int
     *   'relation-type' array of relation-types as string constants
     * )
     *
     * @param  array $p_filter
     */
    public function __construct(array $p_filter)
    {
        $this->m_filter = $p_filter;
    }
}
