<?php
/**
 * i-doit
 *
 * Analytics dataquality DAO.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */
class isys_analytics_dao_dataquality extends isys_cmdb_dao
{
	protected $m_profile_table_fields = array(
		'id' => 'convert_sql_id',
		'title' => 'convert_sql_text',
		'data' => 'convert_sql_text',
		'isys_obj__id' => 'convert_sql_id'
	);

	/**
	 * Method for retrieving profiles.
	 *
	 * @param   integer  $p_profile_id
	 * @param   integer  $p_user_obj_id
	 * @return  isys_component_dao_result
	 */
	public function get_profiles ($p_profile_id = null, $p_user_obj_id = null)
	{
		$l_sql = 'SELECT *
			FROM isys_analytics_dataquality_profiles
			WHERE TRUE';

		if ($p_profile_id !== null)
		{
			$l_sql .= ' AND isys_analytics_dataquality_profiles__id = ' . $this->convert_sql_id($p_profile_id);
		} // if

		// We want to select all profiles, a certain user may see: his own + the public ones.
		if ($p_user_obj_id !== null)
		{
			$l_sql .= ' AND (isys_analytics_dataquality_profiles__isys_obj__id = ' . $this->convert_sql_id($p_user_obj_id) . ' OR isys_analytics_dataquality_profiles__isys_obj__id IS NULL)';
		} // if

		return $this->retrieve($l_sql . ' ORDER BY isys_analytics_dataquality_profiles__title ASC;');
	} // function


	/**
	 * Method for creating/saving profiles.
	 *
	 * @param   integer  $p_profile_id
	 * @param   array    $p_data
	 * @return  boolean
	 */
	public function save_profile ($p_profile_id = null, array $p_data)
	{
		if ($p_profile_id === null)
		{
			$l_sql = 'INSERT INTO isys_analytics_dataquality_profiles SET %s;';
		}
		else
		{
			$l_sql = 'UPDATE isys_analytics_dataquality_profiles SET %s WHERE isys_analytics_dataquality_profiles__id = ' . $this->convert_sql_id($p_profile_id) . ';';
		} // if

		$l_assignments = array();

		foreach ($p_data as $l_field => $l_value)
		{
			if (array_key_exists($l_field, $this->m_profile_table_fields))
			{
				$l_method = $this->m_profile_table_fields[$l_field];

				$l_assignments[] = 'isys_analytics_dataquality_profiles__' . $l_field . ' = ' . $this->$l_method($l_value);
			} // if
		} // foreach

		if (count($l_assignments))
		{
			return $this->update(sprintf($l_sql, implode(', ', $l_assignments))) && $this->apply_update();
		} // if

		return true;
	} // function


	/**
	 * Method for deleting a given profile.
	 *
	 * @param   integer  $p_profile_id
	 * @return  boolean
	 */
	public function delete_profile ($p_profile_id)
	{
		return ($this->update('DELETE FROM isys_analytics_dataquality_profiles WHERE isys_analytics_dataquality_profiles__id = ' . $this->convert_sql_id($p_profile_id) . ';') && $this->apply_update());
	} // function
} // class