<div id="dataquality-result">
    [{foreach $object_types as $obj_type}]
    [{if $obj_type.obj_count > 0}]
    <div>
        <h3 class="gradient" data-objtype-id="[{$obj_type.id}]" data-objtype-const="[{$obj_type.const}]">
            <button class="btn btn-small fr remove-objtype" type="button" title="[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__REMOVE_OBJECTTYPE"}]">
                <img src="[{$dir_images}]icons/silk/cross.png" />
            </button>

            <img class="vat mr5" src="[{$obj_type.icon}]" />
            <span>[{$obj_type.title}]</span>
            <small class="ml10 text-grey">([{$obj_type.obj_count_string}])</small>
        </h3>
        <div class="obj-type-container">

            <table style="width:100%;">
                <tr>
                    <td class="vat" style="width:50%;">
                        <p class="mt5 mb5">
                            <img src="[{$dir_images}]ajax-loading.gif" class="mr5 vam" />
                            <span class="vam">[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]</span>
                        </p>
                        <div class="progress">
                            <div class="progress-bar" style="width:0; background-color:transparent;"></div>
                        </div>
                        <div class="detail" style="display:none; position:relative;"></div>
                    </td>
                    <td class="vat" style="width:50%;">
                        <button class="btn disabled toggle-detail mr5" type="button" data-open="0" disabled="disabled">
                            <img src="[{$dir_images}]icons/silk/bullet_arrow_right.png" class="mr5">
                            <span>[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__SHOW_DETAIL_DATA"}]</span>
                        </button>

                        <button class="btn disabled reset-categories" type="button" disabled="disabled" title="[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__RESET_CATEGORIES_DESCRIPTION"}]">
                            <img src="[{$dir_images}]icons/silk/arrow_refresh.png" class="mr5">
                            <span>[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__RESET_CATEGORIES"}]</span>
                        </button>

                        <div class="detail" style="display:none; position:relative;"></div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    [{/if}]
    [{/foreach}]
</div>

<div id="profile-configuration" style="display:none;">
    <h3 class="popup-header">
        <img class="fr mouse-pointer close" alt="x" src="[{$dir_images}]prototip/styles/default/close.png">
        <span>[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__SAVE_AS_NEW_PROFILE"}]</span>
    </h3>

    <div class="popup-content">
        <table class="contentTable">
            <tr>
                <td class="key">[{isys type="f_label" name="C__ANALYTICS__PROFILE_NAME" ident="LC_UNIVERSAL__NAME"}]</td>
                <td class="value">[{isys type="f_text" name="C__ANALYTICS__PROFILE_NAME" p_strClass="input-small"}]</td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" name="C__ANALYTICS__PROFILE_USERSPECIFIC" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__USER_SPECIFIC"}]</td>
                <td class="value">[{isys type="f_dialog" name="C__ANALYTICS__PROFILE_USERSPECIFIC" p_strClass="input-small" p_bDbFieldNN=true}]</td>
            </tr>
        </table>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn save mr5"><img src="[{$dir_images}]icons/silk/disk.png" class="mr5" /><span>Speichern</span></button>
        <button type="button" class="btn close"><img src="[{$dir_images}]icons/silk/cross.png" class="mr5" /><span>Abbrechen</span></button>
    </div>
</div>

<script>
    (function () {
        "use strict";

        var $result_container     = $('dataquality-result'),
            $popup                = $('profile-configuration'),
            $save                 = $('navbar_item_C__NAVMODE__SAVE'),
            $save_as              = $('navbar_item_C__NAVMODE__SAVE_AS'),
            $publish              = $('navbar_item_publish'),
            $purge                = $('navbar_item_purge_profile'),
            $object_type_reset    = $('navbar_item_reset'),
            dataquality_instances = {},
            categories            = '[{$categories|json_encode|escape:"javascript"}]'.evalJSON();

        $('popup').update($popup.show());

        // Include the dataquality class.
        [{include file="`$analyticsPath`reports/js/dataquality.js"}]

        /*
         * This is the initial loop to create all "DataQuality" instances.
         */
        $result_container.select('div.obj-type-container').each(function ($el) {
            dataquality_instances[$el.previous('h3').readAttribute('data-objtype-const')] = new DataQuality($el, {
                categories: categories
            });
        });

        /*
         * The "remove object type" action will filter a given object type from the current profile.
         */
        $result_container.on('click', 'button.remove-objtype', function (ev) {
            var $button           = ev.findElement('button'),
                object_type_const = $button.up('h3').readAttribute('data-objtype-const');

            new Effect.BlindUp($button.up('div'), {
                duration:    0.5,
                afterFinish: function (effect) {
                    delete dataquality_instances[object_type_const];
                    effect.element.remove();
                }
            });
        });

        /*
         * "collect_data" function for collecting all "object-type <-> category" configurations in a clean format.
         */
        var collect_data = function () {
            var data = {},
                object_type_const,
                category_const;

            for (object_type_const in dataquality_instances) {
                if (dataquality_instances.hasOwnProperty(object_type_const)) {
                    if (Object.isUndefined(data[object_type_const])) {
                        data[object_type_const] = [];
                    }

                    for (category_const in dataquality_instances[object_type_const].data) {
                        if (dataquality_instances[object_type_const].data.hasOwnProperty(category_const)) {
                            data[object_type_const].push(category_const);
                        }
                    }
                }
            }

            return data;
        };

        /*
         * "Save" action (navbar) for saving the current configuration (may call "Save as" action).
         */
        if ($save) {
            $save.writeAttribute('onclick', null).on('click', function () {
                if ('[{$profile_id}]' > 0) {
                    new Ajax.Request('[{$ajax_url}]&func=save-profile&[{$smarty.const.C__ANALYTICS__REPORT_PROFILE}]=[{$profile_id}]', {
                        parameters: {
                            data: Object.toJSON(collect_data())
                        },
                        onComplete: function (response) {
                            var json = response.responseJSON;

                            if (!is_json_response(response, true)) {
                                return;
                            }

                            if (!json.success) {
                                idoit.Notify.error(json.message);
                                return;
                            }

                            window.location.reload();
                        }
                    });
                } else {
                    if ($save_as) {
                        $save_as.simulate('click');
                    } else {
                        popup_open('popup', 640, 140);
                    }
                }
            });
        }

        /*
         * "Save as" action (navbar) for opening a small popup and save the current configuration as a new profile.
         */
        if ($save_as) {
            $save_as.on('click', function () {
                popup_open('popup', 640, 140);
            });
        }

        /*
         * "Close" action (popup) for closing the "Save as" popup.
         */
        $popup.on('click', '.close', function () {
            popup_close();
        });

        /*
         * "Save" action (popup) for saving the current configuration as a new profile.
         */
        $popup.on('click', '.save', function (ev) {
            ev.findElement('button')
                .down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif')
                .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

            new Ajax.Request('[{$ajax_url}]&func=save-profile-as', {
                parameters: {
                    data:          Object.toJSON(collect_data()),
                    title:         $F('C__ANALYTICS__PROFILE_NAME'),
                    user_specific: $F('C__ANALYTICS__PROFILE_USERSPECIFIC')
                },
                onComplete: function (response) {
                    var json = response.responseJSON;

                    if (!is_json_response(response, true)) {
                        return;
                    }

                    if (!json.success) {
                        idoit.Notify.error(json.message);
                        return;
                    }

                    idoit.Notify.success('[{isys type="lang" ident="LC__INFOBOX__DATA_WAS_SAVED"}]');

                    window.location.href = json.data;
                }
            });
        });

        /*
         * "Reset" action (navbar) for displaying all previously filtered object types.
         */
        if ($object_type_reset) {
            $object_type_reset.on('click', function () {
                this.down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif');

                window.location.href = window.location.href + '&reset=all';
            });
        }

        /*
         * "Publish" action (navbar) for publishing a user specific profile for all.
         */
        if ($publish) {
            $publish.on('click', function () {
                if (confirm('[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__MAKE_PUBLIC_CONFIRM" p_bHtmlEncode=false}]')) {
                    $publish.down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif');

                    new Ajax.Request('[{$ajax_url}]&func=publish-profile', {
                        onComplete: function (response) {
                            var json = response.responseJSON;

                            if (!is_json_response(response, true)) {
                                return;
                            }

                            if (!json.success) {
                                idoit.Notify.error(json.message);
                                return;
                            }

                            idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__MAKE_PUBLIC_NOTIFY"}]');

                            $publish.remove();
                        }
                    });
                }
            });
        }

        /*
         * "Purge" action (navbar) for deleting a profile permanently.
         */
        if ($purge) {
            $purge.on('click', function () {
                if (confirm('[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__PURGE_CONFIRM" p_bHtmlEncode=false}]')) {
                    new Ajax.Request('[{$ajax_url}]&func=delete-profile', {
                        onComplete: function (response) {
                            var json = response.responseJSON;

                            if (!is_json_response(response, true)) {
                                return;
                            }

                            if (!json.success) {
                                idoit.Notify.error(json.message);
                                return;
                            }

                            idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__MAKE_PUBLIC_NOTIFY"}]');

                            document.location.href = json.data;
                        }
                    });
                }
            });
        }
    }());
</script>

<style type="text/css">
    #dataquality-result {
        background: #fff;
    }

    #dataquality-result h4 {
        padding: 5px;
        border-top: 1px solid #888;
        border-left: 1px solid #888;
        border-right: 1px solid #888;
    }

    #dataquality-result h3 {
        padding: 5px;
        border-top: 1px solid #888;
        border-bottom: 1px solid #888;
    }

    #dataquality-result div:first-child h3 {
        border-top-width: 0;
    }

    #dataquality-result h3 button {
        margin-top: -2px;
    }

    #dataquality-result div.obj-type-container {
        margin: 5px 5px 15px;
    }

    .obj-type-container td:first-child {
        padding-right: 15px;
    }

    #dataquality-result h3 img {
        max-width: 16px;
        max-height: 16px;
    }

    .detail .progress,
    .detail .progress-bar {
        height: 3px;
    }

    #dataquality-result svg text {
        font-size: 15px;
    }

    #dataquality-result svg .arc {
        transition: opacity 500ms;
        -moz-transition: opacity 500ms;
        -webkit-transition: opacity 500ms;
    }

    #dataquality-result svg .filtered {
        opacity: 0.25;
    }
</style>
