// This is necessary for a lot of "onclick" events.
var result_tree;

(function () {
    'use strict';
    
    var simulation_objects       = [],
        simulation_objects_nodes = [],
        tree_data                = {},
        result_filter            = '',
        $simulation_starter      = $('navbar_item_simulation'),
        $result_tree             = $('result_tree'),
        $monitoring_loader       = $('monitoring_instance_loader'),
        $report_loader           = $('report_loader'),
        $result_filter           = $('impact_itservice_result_filter'),
        $result_filter_button    = $('impact_itservice_result_filter_button');
    
    new Tabs('result-tabs', {
        wrapperClass: 'browser-tabs',
        contentClass: 'result-tab-content',
        tabClass:     'text-shadow mouse-pointer'
    });
    
    new Tabs('selection-tabs', {
        wrapperClass: 'browser-tabs',
        contentClass: 'selection-tab-content',
        tabClass:     'text-shadow mouse-pointer'
    });
    
    if ($monitoring_loader) {
        $monitoring_loader.on('click', function (ev) {
            var monitoring = $F('monitoring_instances'),
                $button    = ev.findElement('button');
            
            if (monitoring > 0) {
                $button.down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif');
                
                new Ajax.Request('[{$ajax_url}]&func=load-not-ok-objects', {
                    parameters: {
                        monitoring: monitoring
                    },
                    onComplete: function (response) {
                        var json              = response.responseJSON,
                            $container        = $('monitoring-result-container').update(),
                            $object_selection = $('impact_obj_selection__HIDDEN'),
                            i, i2, obj, serv, appendix;
                        
                        $button.down('img').writeAttribute('src', '[{$dir_images}]icons/silk/database.png');
                        is_json_response(response, true);
                        
                        if (json.success) {
                            if (json.data.hosts.length === 0 && json.data.services.length === 0) {
                                idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SIMULATION__NO_OBJECTS_FOUND"}]', {life: 5});
                            } else {
                                for (i in json.data.hosts) {
                                    if (json.data.hosts.hasOwnProperty(i)) {
                                        obj = json.data.hosts[i];
                                        
                                        $container
                                            .insert(new Element('label')
                                                .update(new Element('input', {
                                                    type:      'checkbox',
                                                    value:     i,
                                                    className: 'vam mr10',
                                                    checked:   true
                                                }))
                                                .insert(new Element('strong', {className: obj.state.color})
                                                    .update(new Element('img', {
                                                        className: 'vam mr5 mouse-help',
                                                        src:       '[{$dir_images}]' + obj.state.icon,
                                                        title:     obj.state_info
                                                    }))
                                                    .insert(new Element('span').update(obj.state.state)))
                                                .insert(new Element('span', {className: 'ml10'}).update(obj.obj_type_title + ' » ' + obj.obj_title))
                                                .insert(new Element('a', {
                                                    className: 'ml10',
                                                    target:    '_blank',
                                                    href:      '?[{$smarty.const.C__CMDB__GET__OBJECT}]=' + i
                                                }).update(new Element('img', {
                                                    className: 'vam',
                                                    src:       '[{$dir_images}]icons/silk/link.png',
                                                    title:     '[{isys type="lang" ident="LC__UNIVERSAL__TITLE_LINK"}]'
                                                }))));
                                    }
                                }
                                
                                for (i in json.data.services) {
                                    if (json.data.services.hasOwnProperty(i)) {
                                        obj = json.data.services[i];
                                        
                                        appendix = [];
                                        
                                        for (i2 in obj.host_service) {
                                            if (obj.host_service.hasOwnProperty(i2)) {
                                                serv = obj.host_service[i2];
                                                
                                                appendix.push(
                                                    new Element('span', {className: 'mr10 service-sign border-' + serv.state.color + ' ' + serv.state.color})
                                                        .update(new Element('img', {
                                                            className: 'vam mr5 mouse-help',
                                                            src:       '[{$dir_images}]' + serv.state.icon,
                                                            title:     serv.state_info,
                                                            width:     '12px',
                                                            height:    '12px'
                                                        }))
                                                        .insert(new Element('strong').update(serv.state.state))
                                                        .insert(
                                                            new Element('span', {className: 'ml10'}).update(
                                                                '"' + serv.service + '" [{isys type="lang" ident="LC__UNIVERSAL__ON"}] ' + serv.app_type_title + ' » ' + serv.app_title
                                                            )
                                                        )
                                                        .outerHTML
                                                );
                                            }
                                        }
                                        
                                        for (i2 in obj.inherited_service) {
                                            if (obj.inherited_service.hasOwnProperty(i2)) {
                                                serv = obj.inherited_service[i2];
                                                
                                                appendix.push(
                                                    new Element('span', {className: 'mr10 service-sign border-' + serv.state.color + ' ' + serv.state.color})
                                                        .update(new Element('img', {
                                                            className: 'vam mr5 mouse-help',
                                                            src:       '[{$dir_images}]' + serv.state.icon,
                                                            title:     serv.state_info,
                                                            width:     '12px',
                                                            height:    '12px'
                                                        }))
                                                        .insert(new Element('strong').update(serv.state.state))
                                                        .insert(
                                                            new Element('span', {className: 'ml10'}).update(
                                                                '"' + serv.service + '" [{isys type="lang" ident="LC__UNIVERSAL__ON"}] ' + serv.app_type_title + ' » ' + serv.app_title
                                                            )
                                                        )
                                                        .outerHTML
                                                );
                                            }
                                        }
                                        
                                        $container
                                            .insert(new Element('label')
                                                .update(new Element('input', {
                                                    type:      'checkbox',
                                                    value:     i,
                                                    className: 'vam mr10',
                                                    checked:   true
                                                }))
                                                .insert(new Element('strong', {className: obj.state.color})
                                                    .update(new Element('img', {
                                                        className: 'vam mr5 mouse-help',
                                                        src:       '[{$dir_images}]' + obj.state.icon,
                                                        title:     obj.state_info
                                                    }))
                                                    .insert(new Element('span').update(obj.state.state)))
                                                .insert(new Element('span', {className: 'ml10'}).update(obj.obj_type_title + ' » ' + obj.obj_title))
                                                .insert(new Element('a', {
                                                    className: 'ml10 mr10',
                                                    target:    '_blank',
                                                    href:      '?[{$smarty.const.C__CMDB__GET__OBJECT}]=' + i
                                                }).update(new Element('img', {
                                                    className: 'vam',
                                                    src:       '[{$dir_images}]icons/silk/link.png',
                                                    title:     '[{isys type="lang" ident="LC__UNIVERSAL__TITLE_LINK"}]'
                                                })))
                                                .insert(appendix.join('')));
                                    }
                                }
                                
                                $object_selection.setValue(Object.toJSON($container.select('input[type="checkbox"]:checked').invoke('getValue').map(function (n) {
                                    return +n;
                                })));
                                
                                $container.on('change', 'input[type="checkbox"]', function () {
                                    $object_selection.setValue(Object.toJSON($container.select('input[type="checkbox"]:checked').invoke('getValue').map(function (n) {
                                        return +n;
                                    })));
                                });
                            }
                        } else {
                            idoit.Notify.error(json.message, {sticky: true});
                            $container.update(new Element('div', {className: 'p5 box-red'}).update(json.message));
                        }
                    }
                });
            } else {
                idoit.Notify.warning('[{isys type="lang" ident="LC__MODULE__ANALYTICS__FAIL_SIMULATION__NO_MONITORING_INSTANCE"}]', {life: 5});
            }
        });
    }
    
    if ($report_loader) {
        $report_loader.on('click', function (ev) {
            var report  = $F('report_list'),
                $button = ev.findElement('button');
            
            if (report > 0) {
                $button.down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif');
                
                new Ajax.Request('[{$ajax_url}]&func=load-report-impact-objects', {
                    parameters: {
                        report: report
                    },
                    onComplete: function (response) {
                        var json                  = response.responseJSON,
                            i,
                            obj_browser_view      = $('impact_obj_selection__VIEW'),
                            obj_browser_hidden    = $('impact_obj_selection__HIDDEN'),
                            append_browser_view   = [],
                            append_browser_hidden = [];
                        
                        $button.down('img').writeAttribute('src', '[{$dir_images}]icons/silk/database.png');
                        is_json_response(response, true);
                        
                        if (json.success) {
                            for (i in json.data) {
                                if (json.data.hasOwnProperty(i)) {
                                    append_browser_view.push(json.data[i].isys_obj_type__title + ' » ' + json.data[i].isys_obj__title);
                                    append_browser_hidden.push(parseInt(json.data[i].isys_obj__id));
                                }
                            }
                            
                            obj_browser_view.setValue(append_browser_view.join());
                            obj_browser_hidden.setValue(Object.toJSON(append_browser_hidden))
                        } else {
                            idoit.Notify.error(json.message, {sticky: true});
                        }
                    }
                });
            } else {
                idoit.Notify.warning('[{isys type="lang" ident="LC__MODULE__ANALYTICS__FAIL_SIMULATION__NO_REPORTS"}]', {life: 5});
            }
        });
    }
    
    $simulation_starter.on('click', function () {
        var impact_obj = $F('impact_obj_selection__HIDDEN'),
            img        = $simulation_starter.down('img');
        
        if ($simulation_starter.retrieve('running', false)) {
            return;
        }
        
        if (impact_obj.blank()) {
            idoit.Notify.warning('[{isys type="lang" ident="LC__MODULE__ANALYTICS__NOTIFY__NO_IMPACT_OBJECT"}]', {life: 5});
            return;
        }
        
        $simulation_starter.store('running', true);
        
        img.writeAttribute('src', '[{$dir_images}]ajax-loading.gif');
        
        new Ajax.Request('[{$ajax_url}]&func=start-simulation', {
            parameters: {
                'filter':           $F('impact_itservice_filter'),
                'impact_obj':       impact_obj,
                'it_services_only': $F('it_services_only')
            },
            onComplete: function (response) {
                var json              = response.responseJSON,
                    $open_tree_button = new Element('button', {
                        type:      'button',
                        className: 'btn btn-small mt10 mb10'
                    });
                
                $simulation_starter.store('running', false);
                img.writeAttribute('src', '[{$dir_images}]icons/silk/cog.png');
                
                if (!is_json_response(response, true)) {
                    return;
                }
                
                if (!json.success) {
                    idoit.Notify.error(json.message);
                    return;
                }
                
                simulation_objects = json.data.simulation_objects || [];
                tree_data = json.data.tree_data;
                
                display_itservice_table(json.data);
                
                try {
                    result_tree = new dTree('result_tree', '[{$dir_images}]dtree/');
                    
                    result_tree.add(
                        1,
                        -1,
                        tree_data.name,
                        'javascript:',
                        '',
                        '',
                        '[{$dir_images}]icons/silk/application.png',
                        '[{$dir_images}]icons/silk/application.png',
                        '',
                        '',
                        0,
                        ''
                    );
                    
                    create_recursive_jslist(1, tree_data.children, 0);
                    
                    $open_tree_button
                        .update(new Element('img', {
                            src:       '[{$dir_images}]icons/silk/chart_organisation.png',
                            className: 'mr5'
                        }))
                        .insert(new Element('span').update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SIMULATION__HTML_LIST_OPEN_ALL"}]'))
                        .on('click', open_recursive_jslist);
                    
                    $result_tree
                        .update($open_tree_button)
                        .insert(result_tree.toString());
                } catch (e) {
                    idoit.Notify.warning(e, {life: 5});
                    
                    $result_tree
                        .update(create_recursive_htmllist(tree_data.children, true, 0));
                }
                
                // It only makes sense to display the result-filter, if we have selected a filter.
                if ($F('impact_itservice_filter') > 0 && $result_filter_button) {
                    $result_filter_button.writeAttribute('data-switch', 'off')
                        .down('img').writeAttribute('src', '[{$dir_images}]icons/silk/bullet_green.png')
                        .next('span').update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__RESULT_FILTER__SWITCH_ON"}]');
                }
            }
        });
    });
    
    var display_itservice_table = function (data) {
        var $itservice_table = $('result-table').addClassName('border-bottom').down('tbody').update(), $relations, $priority, $tr, $cluster,
            its_id, i, i2    = 0, i3, cluster_count, color, weighting;
        
        for (its_id in data.itservices) {
            if (data.itservices.hasOwnProperty(its_id)) {
                $relations = new Element('ul', {className: 'affected-relation-list'});
                $priority = new Element('strong');
                
                if (data.relation_weighting.hasOwnProperty(its_id)) {
                    for (i in data.relation_weighting[its_id]) {
                        if (data.relation_weighting[its_id].hasOwnProperty(i)) {
                            color = Color.retrieve_color_by_percent(data.relation_weighting[its_id][i].weighting * 10);
                            
                            $cluster = new Element('span');
                            
                            if (data.relation_weighting[its_id][i].cluster_members > 0) {
                                $cluster.addClassName('priority-marker')
                                    .setStyle({background: '#[{$cluster_color}]'})
                                    .update('[{isys type="lang" ident="LC__CMDB__CATG__CLUSTER"}]');
                            }
                            
                            $relations.insert(new Element('li')
                                .update(new Element('strong', {
                                    className: 'priority-marker mr5',
                                    style:     'background:' + color
                                }).update(data.relation_weighting[its_id][i].weighting))
                                .insert($cluster)
                                .insert(data.relation_weighting[its_id][i].title)
                                .insert(new Element('a', {
                                    href:   '?[{$smarty.const.C__CMDB__GET__OBJECT}]=' + data.relation_weighting[its_id][i].id,
                                    target: '_blank'
                                }).update(new Element('img', {
                                    src:       window.dir_images + 'icons/silk/link.png',
                                    className: 'vam ml5',
                                    title:     '[{isys type="lang" ident="LC__UNIVERSAL__TITLE_LINK"}]'
                                }))))
                        }
                    }
                }
                
                if (data.highest_weighting.hasOwnProperty(its_id) && data.highest_weighting[its_id].hasOwnProperty('weighting')) {
                    weighting = data.highest_weighting[its_id].weighting;
                    
                    $priority
                        .addClassName('priority-marker')
                        .setStyle({background: Color.retrieve_color_by_percent(weighting * 10)})
                        .update(weighting + (data.highest_weighting[its_id].cluster === true ? 'C' : ''));
                }
                
                /**
                 * Prepare IT Service Link (first column)
                 * @type Element
                 */
                var $itsLink = new Element('a', {
                    className:   'vam',
                    href:        'javascript:;',
                    'data-name': data.itservices[its_id].name
                }).update(data.itservices[its_id].name);
                
                $itsLink.on('click', function (ev) {
                    if (result_tree) {
                        result_tree.closeAll();
                        
                        var $el        = ev.element(),
                            foundNodes = result_tree.getNodeIdsByName($el.getAttribute('data-name')),
                            i;
                        
                        for (i in foundNodes) {
                            if (foundNodes.hasOwnProperty(i)) {
                                result_tree.openTo(foundNodes[i]);
                            }
                        }
                        
                        foundNodes = result_tree.getNodeIdsByName($el.getAttribute('data-name') + ' [R]');
                        
                        for (i in foundNodes) {
                            if (foundNodes.hasOwnProperty(i)) {
                                result_tree.openTo(foundNodes[i]);
                            }
                        }
                    }
                });
                
                $tr = new Element('tr', {className: (i2 % 2) ? 'line1' : 'line0'})
                    .update(new Element('td', {'data-obj-id': its_id})
                        .update(new Element('img', {
                            src:       data.itservices[its_id].data.icon,
                            className: 'vam mr5'
                        }))
                        .insert($itsLink)
                        .insert(new Element('a', {
                            className: 'vam ml5',
                            href:      '?[{$smarty.const.C__CMDB__GET__OBJECT}]=' + its_id,
                            target:    '_blank'
                        }).update(new Element('img', {
                            src:       window.dir_images + 'icons/silk/link.png',
                            className: 'vam',
                            title:     '[{isys type="lang" ident="LC__UNIVERSAL__TITLE_LINK"}]'
                        }))))
                    .insert(new Element('td').update(data.itservices[its_id].data.itserviceType))
                    .insert(new Element('td').update($priority))
                    .insert(new Element('td').update($relations));
                
                $itservice_table.insert($tr);
                
                i2++;
            }
        }
    };
    
    var open_recursive_jslist = function () {
        result_tree.openAll();
    };
    
    var create_recursive_jslist = function (parent, data, level) {
        var i, node, name;
        
        level++;
        
        for (i in data) {
            if (data.hasOwnProperty(i) && data[i].data) {
                node = parseInt(i) + (parseInt(Math.random() * 9999) + 1000);
                name = data[i].name;
                
                if (simulation_objects.in_array(i) || data[i].data.is_simulation_obj) {
                    name = '<span class="simulation-object">' + name + '</span>';
                }
                
                result_tree.add(
                    node,
                    parent,
                    name,
                    'javascript:',
                    data[i].data.objectType + ' » ' + data[i].name,
                    '',
                    data[i].data.icon,
                    data[i].data.icon,
                    '',
                    '',
                    0,
                    '',
                    'level-' + level + ' obj-type-id-' + data[i].data.objTypeID
                );
                
                if (simulation_objects.in_array(i) || data[i].data.is_simulation_obj) {
                    simulation_objects_nodes.push(node);
                }
                
                if (data[i].children.length !== 0) {
                    create_recursive_jslist(node, data[i].children, level);
                }
            }
        }
    };
    
    var create_recursive_htmllist = function (data, root, level) {
        var $ol = new Element('ul', {className: 'css-tree'}), $li, i, id, css_class;
        level++;
        
        for (i in data) {
            if (data.hasOwnProperty(i) && data[i].data) {
                $li = new Element('li');
                id = parseInt(i) + (parseInt(Math.random() * 9999) + 1000);
                css_class = 'level-' + level + ' obj-type-id-' + data[i].data.objTypeID;
                
                if (simulation_objects.in_array(parseInt(data[i].id, 10))) {
                    simulation_objects_nodes.push('node_' + id);
                    
                    css_class = 'simulation-object';
                }
                
                if (root) {
                    $li.addClassName('root');
                }
                
                $li.insert(
                    new Element('span')
                        .writeAttribute('id', 'node_' + id)
                        .writeAttribute('class', css_class)
                        .writeAttribute('style', 'background:url("' + data[i].data.icon + '") no-repeat 2px 1px;')
                        .update(data[i].data.objectType + ' &raquo; ' + data[i].name)
                );
                
                if (data[i].children.length) {
                    $li.insert(create_recursive_htmllist(data[i].children, false, level))
                }
                
                $ol.insert($li)
            }
        }
        
        return $ol;
    };
    
    var blingbling = function () {
        // Lets the nested list bling.
        $$('#result_tree .simulation-object').invoke('toggleClassName', 'red');
        
        // This should prevent errors when navigating somewhere else.
        if (typeof blingbling === 'function') {
            setTimeout(function () {
                blingbling();
            }, 1000);
        }
    };
    
    $result_filter.on('change', function () {
        var filter = $result_filter.getValue();
        
        result_filter = [];
        
        $result_filter_button
            .disable()
            .writeAttribute('data-switch', 'off')
            .down('img').writeAttribute('src', '[{$dir_images}]icons/silk/bullet_green.png')
            .next('span').update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__RESULT_FILTER__SWITCH_ON"}]');
        
        hide_filtered_objects([]);
        
        if (filter > 0) {
            new Ajax.Request('?ajax=1&call=itservice&func=get-filter-css-classes', {
                parameters: {
                    filter: filter
                },
                onComplete: function (response) {
                    var json = response.responseJSON;
                    
                    is_json_response(response, true);
                    
                    if (json.success) {
                        result_filter = json.data;
                        
                        $result_filter_button.enable();
                    } else {
                        idoit.Notify.error(json.message);
                    }
                }
            });
        }
    });
    
    $result_filter_button.on('click', function (ev) {
        var $result_filter_button = ev.findElement('button');
        
        if ($result_filter_button.readAttribute('data-switch') == 'on') {
            $result_filter_button.writeAttribute('data-switch', 'off')
                .down('img').writeAttribute('src', '[{$dir_images}]icons/silk/bullet_green.png')
                .next('span').update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__RESULT_FILTER__SWITCH_ON"}]');
            
            hide_filtered_objects([]);
        } else {
            $result_filter_button.writeAttribute('data-switch', 'on')
                .down('img').writeAttribute('src', '[{$dir_images}]icons/silk/bullet_red.png')
                .next('span').update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__RESULT_FILTER__SWITCH_OFF"}]');
            
            hide_filtered_objects(result_filter);
        }
    });
    
    var hide_filtered_objects = function (classes) {
        $result_tree.select('.opacity-30').invoke('removeClassName', 'opacity-30');
        
        if (classes.length) {
            $result_tree.select('.' + classes.join(',.')).invoke('addClassName', 'opacity-30');
        }
    };
    
    blingbling();
}());
