<?php

namespace idoit\Module\Analytics\Controller;

use Exception;
use idoit\Module\Analytics\Model\Profile;
use idoit\Module\Analytics\Model\Util;
use isys_application as Application;
use isys_auth;
use isys_format_json as JSON;
use isys_module_analytics;
use isys_notify;
use isys_register as Register;

/**
 * Class Dataquality
 *
 * @package idoit\Module\Analytics\Controller
 */
class Dataquality extends Main
{
    protected $response;

    public function pre()
    {
        header('Content-Type: application/json');

        $this->response = [
            'success' => true,
            'data'    => null,
            'message' => null
        ];
    }

    /**
     * @param Register $request
     */
    public function loadProfiles(Register $request)
    {
        try {
            $this->response['data'] = [];

            $currentUser = $this->getDi()->get('session')->get_user_id();
            $result = Profile::instance($this->getDi()->get('database'))->getProfiles();

            while ($row = $result->get_row()) {
                // Only display global and private profiles (of the current user).
                if ($row['ownerObjectId'] > 0 && $row['ownerObjectId'] != $currentUser) {
                    continue;
                }

                try {
                    $row['data'] = JSON::decode($row['data']);
                } catch (Exception $e) {
                    isys_notify::warning($e->getMessage(), ['sticky' => true]);
                    $row['data'] = [];
                }

                $this->response['data'][] = $row;
            }

            usort($this->response['data'], function ($a, $b) {
                return strnatcasecmp($a['title'], $b['title']);
            });
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }

    /**
     * @param Register $request
     */
    public function loadCategoriesByObjectType(Register $request)
    {
        try {
            $this->response['data'] = [];

            $post = $request->get('POST');
            $language = $this->getDi()->get('language');

            $result = Util::instance($this->getDi()->get('database'))->getCategoriesByObjectType($post['objectTypeConst']);

            while ($row = $result->get_row()) {
                $row['title'] = $language->get($row['title']);
                $row['type'] = $language->get($row['type']);

                $this->response['data'][] = $row;
            }

            usort($this->response['data'], function($a, $b) {
                return strnatcasecmp($a['title'], $b['title']);
            });
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }

    /**
     * @param Register $request
     */
    public function saveProfiles(Register $request)
    {
        try {
            $this->response['data'] = [];

            $post = $request->get('POST');

            $auth = isys_module_analytics::getAuth();
            $data = JSON::decode($post['data']);
            $profileModel = Profile::instance($this->getDi()->get('database'));

            foreach ($data as $profile) {
                $id = $profile['id'];
                $profile['isys_obj__id'] = $profile['ownerObjectId'];

                if (strpos($id, 'new-') === 0) {
                    $id = null;
                }

                unset ($profile['id']);

                $profileModel->saveProfile($id, $profile);
            }

            // Prepare the profiles to be deleted (only delete profiles that actually exist).
            $deletedProfiles = array_filter((array)JSON::decode($post['deletedData']), function($profileId) use ($auth) {
                return strpos($profileId, 'new-') === false && $auth->is_allowed_to(isys_auth::DELETE, 'DATAQUALITY/' . $profileId);
            });

            if (count($deletedProfiles)) {
                $profileModel->deleteProfiles($deletedProfiles);
            }
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }

    public function post()
    {
        echo JSON::encode($this->response);
        die;
    }
}
