<?php

namespace idoit\Module\Analytics\Model;

use idoit\Model\Dao\Base;
use isys_analytics_reports_dataquality;
use isys_component_dao_result;
use isys_format_json as JSON;

/**
 * Class Util
 *
 * @package idoit\Module\Analytics\Model
 */
class Util extends Base
{
    /**
     * @param string $objectTypeConstant
     *
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getCategoriesByObjectType(string $objectTypeConstant): isys_component_dao_result
    {
        $sql = 'SELECT isys_obj_type__id AS id
            FROM isys_obj_type
            WHERE isys_obj_type__const = ' . $this->convert_sql_text($objectTypeConstant) . '
            LIMIT 1';

        $objectTypeId = $this->convert_sql_id($this->retrieve($sql)->get_row_value('id'));

        $sql = "SELECT isysgui_catg__title AS title, isysgui_catg__const AS const, 'LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__TYPE_GLOBAL' AS type  
            FROM isysgui_catg 
            INNER JOIN isys_obj_type_2_isysgui_catg ON isys_obj_type_2_isysgui_catg__isysgui_catg__id = isysgui_catg__id
            WHERE isys_obj_type_2_isysgui_catg__isys_obj_type__id = {$objectTypeId}
            
            UNION
            
            SELECT isysgui_catg_custom__title AS title, isysgui_catg_custom__const AS const, 'LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__TYPE_CUSTOM' AS type
            FROM isysgui_catg_custom 
            INNER JOIN isys_obj_type_2_isysgui_catg_custom ON isys_obj_type_2_isysgui_catg_custom__isysgui_catg_custom__id = isysgui_catg_custom__id
            WHERE isys_obj_type_2_isysgui_catg_custom__isys_obj_type__id  = {$objectTypeId}
            
            UNION

            SELECT isysgui_cats__title AS title, isysgui_cats__const AS const, 'LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__TYPE_SPECIFIC' AS type
            FROM isysgui_cats 
            INNER JOIN isys_obj_type ON isys_obj_type__isysgui_cats__id = isysgui_cats__id
            WHERE isys_obj_type__id  = {$objectTypeId};";

        return $this->retrieve($sql);
    }

    /**
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getObjectTypes(): isys_component_dao_result
    {
        // Prepare blacklist.
        $objectTypeConstants = implode(',', array_map(function($constant) {
            return $this->convert_sql_text($constant);
        }, isys_analytics_reports_dataquality::OBJECT_TYPE_BLACKLIST));

        $sql = "SELECT isys_obj_type__title AS title, isys_obj_type__const AS const
            FROM isys_obj_type
            WHERE isys_obj_type__const NOT IN ({$objectTypeConstants});";

        return $this->retrieve($sql);
    }
}
