<div id="popup-analytics-profiles">
    <h3 class="popup-header">
        <img class="fr mouse-pointer popup-closer" alt="x" src="[{$dir_images}]icons/close-circle.png">
        <span>[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__MANAGE_PROFILES_DESCRIPTION"}]</span>
    </h3>

    <div class="popup-content" id="popup-analytics-profiles-content">
        <!-- Will be filled by JS -->
    </div>

    <div class="popup-footer">
        <button type="button" class="btn">
            <img src="[{$dir_images}]icons/silk/disk.png" class="mr5" />
            <span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_SAVE"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]icons/silk/cross.png" class="mr5" />
            <span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        const $popup = $('popup-analytics-profiles');
        const objectTypes = JSON.parse('[{$objectTypes|json_encode|escape:"javascript"}]')

        $popup.on('click', '.popup-closer', function () {
            popup_close();
        });

        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__ADD_NEW_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__ADD_NEW_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__EDIT_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__EDIT_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__RENAME_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__RENAME_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__DELETE_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__DELETE_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__DUPLICATE_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__DUPLICATE_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__OBJECT_TYPES', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__OBJECT_TYPES" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__CATEGORIES', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__CATEGORIES" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY__PURGE_CONFIRM', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__PURGE_CONFIRM" p_bHtmlEncode=false}]');

        idoit.Require.addModule('analytics.profile-manager', '[{$assetsWwwDir}]js/profile-manager.js');

        idoit.Require.require('analytics.profile-manager', function () {
            const profileManager = new ProfileManager($('popup-analytics-profiles-content'), {
                objectTypes: objectTypes
            });

            $popup.down('.popup-footer button').on('click', function () {
                new Ajax.Request(window.www_dir + 'analytics/dataquality/saveProfiles', {
                    parameters: {
                        data: JSON.stringify(profileManager.getProfiles()),
                        deletedData: JSON.stringify(profileManager.getDeletedProfiles())
                    },
                    onComplete: function (xhr) {
                        var json = xhr.responseJSON;

                        if (json.success) {
                            popup_close();
                            idoit.Notify.success('[{isys type="lang" ident="LC__INFOBOX__DATA_WAS_SAVED"}]', {sticky: true});
                            document.location.reload(true);
                        } else {
                            idoit.Notify.error(json.message, {sticky: true});
                        }
                    }
                });
            });
        });
    })();
</script>

<style type="text/css">
    #popup-analytics-profiles-content {
        display: flex;
        justify-content: space-between;
        align-items: stretch;
    }

    #popup-analytics-profiles-content * {
        box-sizing: border-box;
        user-select: none;
    }

    #popup-analytics-profiles-content .overlay {
        position: absolute;
        background-color: rgba(255, 255, 255, .8);
        top: 0;
        right: 0;
        bottom: 0;
        left: 230px;
    }

    #popup-analytics-profiles-content > div:not(.overlay) {
        flex: 1 1 auto;
        max-width: 35%;
    }

    #popup-analytics-profiles-content > div:not(.overlay):first-child {
        max-width: 25%;
        margin-right: 20px;
    }

    #popup-analytics-profiles-content ul {
        margin: 0;
        padding: 0;
        list-style: none;
        height: 440px;
        overflow-y: auto;
    }

    #popup-analytics-profiles-content li {
        border-bottom: 1px solid #aaa;
        padding: 5px;
        position: relative;
        transition: background-color 150ms;
    }

    #popup-analytics-profiles-content li.active {
        background-color: #eee;
    }

    #popup-analytics-profiles-content li.not-selected {
        background-color: #f5f5f5;
    }

    #popup-analytics-profiles-content li:hover {
        background-color: #e0e0e0;
    }

    #popup-analytics-profiles-content li input {
        position: absolute;
        top: 10px;
        left: 8px;
    }

    #popup-analytics-profiles-content li span {
        margin-left: 25px;
    }

    #popup-analytics-profiles-content li span,
    #popup-analytics-profiles-content li strong {
        line-height: 25px;
        display: block;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    #popup-analytics-profiles-content li button {
        opacity: 0;
        transition: opacity 150ms;
        position: absolute;
    }

    #popup-analytics-profiles-content li:hover button {
        opacity: 1;
    }
</style>