<?php
/**
 * i-doit
 *
 * Analytics helper.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */
class isys_analytics_helper
{
	public static function get_all_simulations ()
	{
		$l_return = array();
		$l_dirs = new DirectoryIterator(dirname(__DIR__) . '/reports/');

		// Here we create a menu item for each found report.
		foreach ($l_dirs as $l_dir)
		{
			/** @var  $l_dir  DirectoryIterator */
			if (! $l_dir->isDot())
			{
				$l_classname = strstr($l_dir->getFilename(), '.', true);

				if (class_exists($l_classname) && $l_classname != 'isys_analytics_reports')
				{
					/** @var  $l_class  isys_analytics_reports */
					$l_class = isys_factory::get_instance($l_classname);

					if (method_exists($l_class, 'display_in_tree') && ! $l_class->display_in_tree())
					{
						continue;
					} // if

					$l_return[$l_classname] = $l_class;
				} // if
			} // if
		} // foreach

		return $l_return;
	} // function
} // class