<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */

define('C__ANALYTICS__REPORT', 'report');
define('C__ANALYTICS__REPORT_PROFILE', 'profile');

if (isys_module_manager::instance()->is_active('analytics'))
{
	if (include_once('isys_module_analytics_autoload.class.php'))
	{
		spl_autoload_register('isys_module_analytics_autoload::init');
	} // if

    $l_lang = isys_application::instance()->language;

	if (file_exists(__DIR__ . '/lang/' . $l_lang . '.inc.php'))
	{
		$l_language = include_once __DIR__ . '/lang/' . $l_lang . '.inc.php';

		if (is_array($l_language))
		{
			global $g_comp_template_language_manager;
			$g_comp_template_language_manager->append_lang($l_language);
		} // if
	} // if

    if (class_exists('\idoit\Psr4AutoloaderClass'))
    {
        \idoit\Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Analytics', __DIR__ . '/src/');
    } // if

    isys_application::instance()->container->signals->connect('mod.cmdb.processMenuTreeLinks', array('isys_module_analytics', 'process_menu_tree_links'));
} // if