<?php
/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */

class isys_module_analytics_autoload extends isys_module_manager_autoload
{
	/**
	 * Module specific autoloader.
	 *
	 * @param   string  $p_classname
	 * @return  boolean
	 */
	public static function init ($p_classname)
	{
        $l_classlist = [
            'isys_auth_analytics'                      => '/src/classes/modules/analytics/auth/isys_auth_analytics.class.php',
            'isys_analytics_dao'                       => '/src/classes/modules/analytics/dao/isys_analytics_dao.class.php',
            'isys_analytics_dao_dataquality'           => '/src/classes/modules/analytics/dao/isys_analytics_dao_dataquality.class.php',
            'isys_ajax_handler_analytics'              => '/src/classes/modules/analytics/handler/ajax/isys_ajax_handler_analytics.class.php',
            'isys_analytics_helper'                    => '/src/classes/modules/analytics/helper/isys_analytics_helper.class.php',
            'isys_module_analytics_install'            => '/src/classes/modules/analytics/install/isys_module_analytics_install.class.php',
            'isys_analytics_reports'                   => '/src/classes/modules/analytics/reports/isys_analytics_reports.class.php',
            'isys_analytics_reports_dataquality'       => '/src/classes/modules/analytics/reports/isys_analytics_reports_dataquality.class.php',
            'isys_analytics_reports_impact_simulation' => '/src/classes/modules/analytics/reports/isys_analytics_reports_impact_simulation.class.php',
            'isys_analytics_reports_livestatus'        => '/src/classes/modules/analytics/reports/isys_analytics_reports_livestatus.class.php',
            'isys_analytics_reports_obj_catalog'       => '/src/classes/modules/analytics/reports/isys_analytics_reports_obj_catalog.class.php',
            'isys_analytics_reports_servicecosts'      => '/src/classes/modules/analytics/reports/isys_analytics_reports_servicecosts.class.php',
            'isys_tree_visitor_analytics'              => '/src/classes/modules/analytics/tree_visitor/isys_tree_visitor_analytics.class.php',
            'isys_tree_visitor_level'                  => '/src/classes/modules/analytics/tree_visitor/isys_tree_visitor_level.class.php',
        ];

        if (isset($l_classlist[$p_classname]))
        {
            if (parent::include_file($l_classlist[$p_classname]))
            {
                isys_caching::factory('autoload')
                    ->set($p_classname, $l_classlist[$p_classname]);

                return true;
            } // if
        } // if

		return false;
	} // function
} // class