<?php

/**
 * i-doit
 *
 * Abstract report class.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */
abstract class isys_analytics_reports
{
    /**
     * Constructor
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    abstract public function __construct();

    /**
     * Method for preparing the visual report view output.
     *
     * @return  isys_analytics_reports
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    abstract public function start();

    /**
     * This method will be called by the framework, to process ajax requests.
     * It should echo a string and then terminate the request (via "die;").
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    abstract public function ajax_request();

    /**
     * Returns the reports title via late static binding.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function get_title()
    {
        return static::TITLE;
    } // function

    /**
     * Returns the reports icon via late static binding.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function get_icon()
    {
        return static::ICON;
    } // function
} // class