<?php

/**
 * i-doit
 *
 * Analytics dataquality DAO.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */
class isys_analytics_dao_dataquality extends isys_cmdb_dao
{
    protected $m_profile_table_fields = [
        'id'           => 'convert_sql_id',
        'title'        => 'convert_sql_text',
        'data'         => 'convert_sql_text',
        'isys_obj__id' => 'convert_sql_id'
    ];

    /**
     * Method for retrieving profiles.
     *
     * @param integer $p_profile_id
     * @param integer $p_user_obj_id
     *
     * @return  isys_component_dao_result
     */
    public function get_profiles($p_profile_id = null, $p_user_obj_id = null)
    {
        $l_sql = 'SELECT *
			FROM isys_analytics_dataquality_profiles
			WHERE TRUE';

        if ($p_profile_id !== null) {
            $l_sql .= ' AND isys_analytics_dataquality_profiles__id = ' . $this->convert_sql_id($p_profile_id);
        }

        // We want to select all profiles, a certain user may see: his own + the public ones.
        if ($p_user_obj_id !== null) {
            $l_sql .= ' AND (isys_analytics_dataquality_profiles__isys_obj__id = ' . $this->convert_sql_id($p_user_obj_id) .
                ' OR isys_analytics_dataquality_profiles__isys_obj__id IS NULL)';
        }

        return $this->retrieve($l_sql . ' ORDER BY isys_analytics_dataquality_profiles__title ASC;');
    }

    /**
     * Method for creating/saving profiles.
     *
     * @param integer $profileId
     * @param array   $p_data
     *
     * @return  boolean
     */
    public function save_profile(int $profileId, array $p_data)
    {
        $l_sql = 'INSERT INTO isys_analytics_dataquality_profiles SET %s;';

        if ($profileId > 0) {
            $l_sql = "UPDATE isys_analytics_dataquality_profiles SET %s WHERE isys_analytics_dataquality_profiles__id = {$profileId};";
        }

        $l_assignments = [];

        foreach ($p_data as $l_field => $l_value) {
            if (array_key_exists($l_field, $this->m_profile_table_fields)) {
                $l_method = $this->m_profile_table_fields[$l_field];

                $l_assignments[] = 'isys_analytics_dataquality_profiles__' . $l_field . ' = ' . $this->$l_method($l_value);
            }
        }

        if (count($l_assignments)) {
            return $this->update(sprintf($l_sql, implode(', ', $l_assignments))) && $this->apply_update();
        }

        return true;
    }

    /**
     * @param int $profileId
     *
     * @return bool
     * @throws isys_exception_dao
     */
    public function delete_profile(int $profileId): bool
    {
        $sql = "DELETE FROM isys_analytics_dataquality_profiles WHERE isys_analytics_dataquality_profiles__id = {$profileId};";

        return $this->update($sql) && $this->apply_update();
    }
}
