<?php

/**
 * i-doit
 *
 * Module initializer
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */

define('C__ANALYTICS__REPORT', 'report');
define('C__ANALYTICS__REPORT_PROFILE', 'profile');

if (isys_module_manager::instance()->is_active('analytics')) {
    if (include_once('isys_module_analytics_autoload.class.php')) {
        spl_autoload_register('isys_module_analytics_autoload::init');
    }

    if (class_exists('\idoit\Psr4AutoloaderClass')) {
        \idoit\Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Analytics', __DIR__ . '/src/');
    }

    isys_application::instance()->container->get('signals')->connect('mod.cmdb.processMenuTreeLinks', ['isys_module_analytics', 'process_menu_tree_links']);

    // @see  ANALYSE-68  Add a route to the dataquality controller.
    isys_request_controller::instance()
        ->addModuleRoute('POST', '/analytics/dataquality/[s:method]', 'analytics', 'Dataquality');
}
