<?php

/**
 * i-doit analytics module installer.
 *
 * @package     i-doit
 * @subpackage  med_dev
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */
class isys_module_analytics_install
{
    /**
     * Init method.
     *
     * @param  isys_component_database $db
     * @param  isys_component_database $dbSystem
     * @param  integer                 $moduleId
     * @param  string                  $type
     * @return null
     */
    public static function init($db, $dbSystem, $moduleId, $type)
    {
        if (!$moduleId) {
            return null;
        }

        if ($type === 'install') {
            $l_dao = isys_cmdb_dao::instance($db);

            $l_sqls = [];
            $l_admin = $l_dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_ADMIN";')->get_row_value('isys_obj__id');
            $l_author = $l_dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_AUTHOR";')->get_row_value('isys_obj__id');
            $l_editor = $l_dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_EDITOR";')->get_row_value('isys_obj__id');

            if ($l_admin > 0) {
                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_admin) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "ANALYTICS_SIMULATION";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_admin) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "ANALYTICS_SIMULATION/' . isys_auth::WILDCHAR . '";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_admin) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "DATAQUALITY";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_admin) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "DATAQUALITY/' . isys_auth::WILDCHAR . '";';
            }

            if ($l_author > 0) {
                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_author) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "ANALYTICS_SIMULATION";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_author) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "ANALYTICS_SIMULATION/' . isys_auth::WILDCHAR . '";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_author) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "DATAQUALITY";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_author) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "DATAQUALITY/' . isys_auth::WILDCHAR . '";';
            }

            if ($l_editor > 0) {
                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_editor) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "ANALYTICS_SIMULATION";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_editor) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "ANALYTICS_SIMULATION/' . isys_auth::WILDCHAR . '";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_editor) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "DATAQUALITY";';

                $l_sqls[] = 'INSERT isys_auth
						SET isys_auth__isys_obj__id = ' . $l_dao->convert_sql_id($l_editor) . ',
						isys_auth__type = ' . $l_dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT + isys_auth::DELETE) . ',
						isys_auth__isys_module__id = ' . $l_dao->convert_sql_id($moduleId) . ',
						isys_auth__path = "DATAQUALITY/' . isys_auth::WILDCHAR . '";';
            }

            if (count($l_sqls)) {
                foreach ($l_sqls as $l_sql) {
                    $l_dao->update($l_sql);
                }
            }

            // Apply the changes.
            $l_dao->apply_update();
        }
    }
}