<?php

use idoit\Module\Analytics\Model\Util;

/**
 * Class isys_popup_analytics_dataquality_profiles
 */
class isys_popup_analytics_dataquality_profiles extends isys_component_popup
{
    /**
     * @param isys_module_request $moduleRequest
     *
     * @return isys_component_template|void
     * @throws isys_exception_database
     */
    public function &handle_module_request(isys_module_request $moduleRequest)
    {
        $objectTypes = [];

        $result = Util::instance($this->database)->getObjectTypes();

        while ($row = $result->get_row()) {
            $objectTypes[] = [
                'title' => $this->language->get($row['title']),
                'const' => $row['const']
            ];
        }

        usort($objectTypes, function($a, $b) {
            return strnatcasecmp($a['title'], $b['title']);
        });

        $this->template
            ->assign('assetsWwwDir', isys_module_analytics::getWwwPath() . 'assets/')
            ->assign('objectTypes', $objectTypes)
            ->display(isys_module_analytics::getPath() . 'templates/popup/dataquality_profiles.tpl');

        die();
    }
}
