<?php

/**
 * i-doit
 *
 * Abstract report class.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */
abstract class isys_analytics_reports
{
    /**
     * @var isys_component_database
     */
    protected $database;

    /**
     * @var isys_component_template
     */
    protected $template;

    /**
     * @var isys_component_template_language_manager
     */
    protected $language;

    /**
     * Constructor
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function __construct()
    {
        $this->database = isys_application::instance()->container->get('database');
        $this->template = isys_application::instance()->container->get('template');
        $this->language = isys_application::instance()->container->get('language');
    }

    /**
     * Method for preparing the visual report view output.
     *
     * @return  isys_analytics_reports
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    abstract public function start();

    /**
     * This method will be called by the framework, to process ajax requests.
     * It should echo a string and then terminate the request (via "die;").
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    abstract public function ajax_request();

    /**
     * Returns the reports title via late static binding.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function getTitle()
    {
        return static::TITLE;
    }

    /**
     * Returns the reports icon via late static binding.
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function getIcon()
    {
        return static::ICON;
    }
}
