<?php

namespace idoit\Module\Analytics\Model;

use idoit\Model\Dao\Base;
use isys_format_json as JSON;

/**
 * Class Profile
 *
 * @package idoit\Module\Analytics\Model
 */
class Profile extends Base
{
    const FIELDS = [
        'isys_analytics_dataquality_profiles__id'     => 'id',
        'isys_analytics_dataquality_profiles__title'  => 'title',
        'isys_analytics_dataquality_profiles__data'  => 'data',
        'isys_analytics_dataquality_profiles__isys_obj__id' => 'ownerObjectId'
    ];

    /**
     * @param int $id
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getProfile(int $id): \isys_component_dao_result
    {
        $select = $this->selectImplode(self::FIELDS);

        $sql = 'SELECT ' . $select . ' 
            FROM isys_analytics_dataquality_profiles 
            WHERE isys_analytics_dataquality_profiles__id = ' . $this->convert_sql_id($id) . ';';

        return $this->retrieve($sql);
    }

    /**
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getProfiles(): \isys_component_dao_result
    {
        $select = $this->selectImplode(self::FIELDS);

        return $this->retrieve('SELECT ' . $select . ' FROM isys_analytics_dataquality_profiles;');
    }

    /**
     * @param int   $id
     * @param array $data
     *
     * @return bool
     * @throws \isys_exception_dao
     */
    public function saveProfile($id, array $data): bool
    {
        $fields = [];

        foreach ($data as $key => $value) {
            $field = 'isys_analytics_dataquality_profiles__' . $key;

            if (!self::FIELDS[$field]) {
                continue;
            }

            switch ($key) {
                default:
                case 'title':
                    $value = $this->convert_sql_text($value);
                    break;

                case 'data':
                    if (!is_scalar($value)) {
                        $value = JSON::encode($value);
                    }

                    $value = $this->convert_sql_text($value);
                    break;

                case 'isys_obj__id':
                case 'ownerObjectId':
                    $value = $this->convert_sql_id($value);
                    break;
            }

            $fields[] = $field . ' = ' . $value;
        }

        if (!count($fields)) {
            return true;
        }

        if ($id === null) {
            $sql = 'INSERT INTO isys_analytics_dataquality_profiles SET ' . implode(', ', $fields) . ';';
        } else {
            $sql = 'UPDATE isys_analytics_dataquality_profiles 
                SET ' . implode(', ', $fields) . ' 
                WHERE isys_analytics_dataquality_profiles__id = ' . $this->convert_sql_id($id) . ';';
        }

        return $this->update($sql) && $this->apply_update();
    }

    /**
     * @param array $ids
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function deleteProfiles(array $ids): \isys_component_dao_result
    {
        $sql = 'DELETE FROM isys_analytics_dataquality_profiles 
            WHERE isys_analytics_dataquality_profiles__id ' . $this->prepare_in_condition($ids) . ';';

        return $this->retrieve($sql);
    }
}
