<?php

/**
 * i-doit
 *
 * Analysis API model.
 *
 * @package    i-doit
 * @subpackage analytics
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_analysis extends isys_api_model implements isys_api_model_interface
{
    /**
     * @param string $method
     * @param array  $parameters
     *
     * @return $this|isys_api_model
     * @throws Exception
     */
    public function route($method, $parameters)
    {
        $className = 'isys_api_model_analysis_' . $method;

        if (!class_exists($className)) {
            throw new Exception('Method "analysis.' . $method . '" does not exist.');
        }

        /** @var isys_api_model_idoit */
        $model = new $className();
        $option = $parameters['option'] ?: 'read';

        if (!method_exists($model, $option)) {
            throw new Exception('The model ' . $method . ' does not contain a "' . $option . '" method.');
        }

        $this->m_data = call_user_func([$model, $option], $parameters);

        return $this;
    }

    /**
     * @param array $parameters
     *
     * @return mixed|null
     */
    public function read($parameters)
    {
        return null;
    }
}