<?php

use idoit\Module\Analytics\Model\Profile;

/**
 * i-doit
 *
 * Analysis API model.
 *
 * @package    i-doit
 * @subpackage analytics
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_analysis_dataquality implements isys_api_model_interface
{
    /**
     * @param array $parameters
     *
     * @return array
     * @throws isys_exception_api
     * @throws isys_exception_database
     */
    public function read($parameters)
    {
        $profileId = (int)$parameters['profileId'];
        $objects = array_unique(array_filter((array)$parameters['objects']));

        if ($profileId === 0) {
            throw new isys_exception_api('You have to pass a profile ID via \'profileId\'.');
        }

        $database = isys_application::instance()->container->get('database');
        $profile = Profile::instance($database)
            ->getProfile($profileId)
            ->get_row();

        if ($profile === null) {
            throw new isys_exception_api('The given profile ID does not exist.');
        }

        $dao = isys_application::instance()->container->get('cmdb_dao');
        $language = isys_application::instance()->container->get('language');
        $qualityResults = [];

        // Get necessary object type constants from the passed object IDs.
        $query = 'SELECT isys_obj__id AS id, isys_obj_type__id AS typeId, isys_obj_type__const AS typeConst
            FROM isys_obj
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
            WHERE isys_obj__id ' . $dao->prepare_in_condition($objects) . ';';

        $result = $dao->retrieve($query);

        $report = new isys_analytics_reports_dataquality();

        $report->setCurrentProfile($profileId);

        $averagePercent = 0;

        while ($row = $result->get_row()) {
            $_SESSION['analytics-data-quality'] = [
                'profile-' . $profileId => [
                    $row['typeConst'] => [
                        $row['id']
                    ]
                ]
            ];

            $documentation = 0;
            $rawResult = $report->loadCategoryData($row['typeId'], false)['data'];

            $numberOfCategories = count($rawResult);
            $filledCategories = count(array_filter($rawResult));

            if ($numberOfCategories > 0) {
                $documentation = ($filledCategories / $numberOfCategories) * 100;
            }

            $objectData = $dao->get_object($row['id'])->get_row();

            $qualityResults[] = [
                'object'  => [
                    'id'     => (int)$row['id'],
                    'title'  => $language->get($objectData['isys_obj__title']),
                    'typeId' => (int)$objectData['isys_obj_type__id'],
                    'type'   => $language->get($objectData['isys_obj_type__title'])
                ],
                'percent' => round($documentation, 2)
            ];

            $averagePercent += $documentation;
        }

        if (count($qualityResults)) {
            $averagePercent /= count($qualityResults);
        }

        return [
            'objects'        => $qualityResults,
            'averagePercent' => round($averagePercent, 2)
        ];
    }

    /**
     * @return array
     * @throws isys_exception_database
     */
    public function profiles()
    {
        $profiles = [];

        $database = isys_application::instance()->container->get('database');
        $result = Profile::instance($database)->getProfiles();

        while ($row = $result->get_row()) {
            $profiles[] = [
                'id' => $row['id'],
                'title' => $row['title'],
            ];
        }

        return $profiles;
    }
}