<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

class isys_module_analytics_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param string $className
     *
     * @return  boolean
     */
    public static function init($className)
    {
        $base = '/src/classes/modules/analytics/';
        $classMap = [
            'isys_api_model_analysis'                   => 'api/isys_api_model_analysis.class.php',
            'isys_api_model_analysis_dataquality'       => 'api/isys_api_model_analysis_dataquality.class.php',
            'isys_analytics_dao'                        => 'dao/isys_analytics_dao.class.php',
            'isys_analytics_dao_dataquality'            => 'dao/isys_analytics_dao_dataquality.class.php',
            'isys_analytics_reports'                    => 'reports/isys_analytics_reports.class.php',
            'isys_analytics_reports_dataquality'        => 'reports/isys_analytics_reports_dataquality.class.php',
            'isys_analytics_reports_impact_simulation'  => 'reports/isys_analytics_reports_impact_simulation.class.php',
            'isys_analytics_reports_livestatus'         => 'reports/isys_analytics_reports_livestatus.class.php',
            'isys_analytics_reports_obj_catalog'        => 'reports/isys_analytics_reports_obj_catalog.class.php',
            'isys_analytics_reports_servicecosts'       => 'reports/isys_analytics_reports_servicecosts.class.php',
            'isys_auth_analytics'                       => 'auth/isys_auth_analytics.class.php',
            'isys_popup_analytics_dataquality_profiles' => 'popups/isys_popup_analytics_dataquality_profiles.class.php',
            'isys_tree_visitor_analytics'               => 'tree_visitor/isys_tree_visitor_analytics.class.php',
            'isys_tree_visitor_level'                   => 'tree_visitor/isys_tree_visitor_level.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($base . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $base . $classMap[$className]);

            return true;
        }

        return false;
    }
}
