<fieldset class="overview">
	<legend class="border-top-none">[{isys type="lang" ident="LC__MODULE__ANALYTICS__OBJECT_CATALOG"}]</legend>
	<div class="p5 mt10">
		<p class="mb5">[{isys type="lang" ident="LC__MODULE__ANALYTICS__OBJECT_CATALOG__OBJECT_SELECTION"}]</p>

		<table class="contentTable" style="padding-top:0;">
			<tr>
				<td class="key">[{isys type="f_label" name="impact_obj_selection" ident="LC__MODULE__ANALYTICS__FAIL_SIMULATION__OBJECT_LABEL"}]</td>
				<td class="value">[{isys name="obj_catalog_selection" type="f_popup" p_strPopupType="browser_object_ng"}]</td>
			</tr>
			<tr>
				<td class="key vat">[{isys type="f_label" name="impact_itservice_filter" ident="LC__MODULE__ANALYTICS__FILTERS"}]</td>
				<td class="value">
					[{isys name="impact_itservice_filter" type="f_dialog" p_strClass="input-small"}]
					<br class="cb" />
					<p class="ml20 text-grey mb5">[{$filter_description}]</p>
				</td>
			</tr>
		</table>

		[{isys name="obj_catalog_attributes" type="f_property_selector" sortable=true}]
	</div>
</fieldset>

<fieldset class="overview" style="margin-top: 15px; background:#f5f5f5;">
	<legend><span>[{isys type="lang" ident="LC__MODULE__ANALYTICS__RESULT"}]</span></legend>
</fieldset>

<table id="result_sum_table" class="mainTable border-bottom" style="margin:8px 0 15px;" cellpadding="0" cellspacing="0">
	<thead>
	<tr>
		<th>[{isys type="lang" ident="LC__MODULE__ANALYTICS__OBJECT_CATALOG__FIELD_KEY"}]</th>
		<th>[{isys type="lang" ident="LC__MODULE__ANALYTICS__OBJECT_CATALOG__FIELD_VALUE"}]</th>
	</tr>
	</thead>
	<tbody></tbody>
</table>

<table id="result_table" class="mainTable border-top" cellpadding="0" cellspacing="0">
	<thead></thead>
	<tbody></tbody>
</table>

<script>
	(function () {
		"use strict";

		var $trigger = $('navbar_item_simulation'),
		    result_table = $('result_table'),
			result_table_head = result_table.down('thead'),
			result_table_body = result_table.down('tbody'),
			result_sum_table = $('result_sum_table').down('tbody');

		$trigger.on('click', function () {
			var itservice_obj = $F('obj_catalog_selection__HIDDEN'),
				attributes = $F('obj_catalog_attributes__HIDDEN'),
				img = $('navbar_item_simulation').down('img');

			if ($trigger.retrieve('running', false)) {
				return;
			}

			$trigger.store('running', true);

			if (itservice_obj.blank()) {
				idoit.Notify.warning('[{isys type="lang" ident="LC__MODULE__ANALYTICS__NOTIFY__NO_IMPACT_OBJECT"}]', {life: 5});
				return;
			}

			if (attributes.blank()) {
				idoit.Notify.warning('[{isys type="lang" ident="LC__MODULE__ANALYTICS__NOTIFY__NO_ATTRIBUTES"}]', {life: 5});
				return;
			}

			img.writeAttribute('src', '[{$dir_images}]ajax-loading.gif');

			new Ajax.Request('[{$ajax_url}]&func=start-simulation', {
				parameters: {
					filter: $F('impact_itservice_filter'),
					itservice_obj: itservice_obj
				},
				onComplete: function (response) {
					var json = response.responseJSON;

					$trigger.store('running', false);

					if (!is_json_response(response, true)) {
						img.writeAttribute('src', window.dir_images + 'axialis/basic/gear.svg');
						return;
					}

					if (!json.success) {
						img.writeAttribute('src', window.dir_images + 'axialis/basic/gear.svg');
						idoit.Notify.error(json.message);
						return;
					}

					if (json.data.length === 0) {
						img.writeAttribute('src', window.dir_images + 'axialis/basic/gear.svg');
						idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__ANALYTICS__OBJECT_CATALOG__FOUND_0_OBJECTS"}]');
						return;
					}

					new Ajax.Request('[{$ajax_url}]&func=retrieve-attributes', {
						parameters: {
							obj_ids: Object.toJSON(json.data),
							attributes: attributes
						},
						onComplete: function (response) {
							var json = response.responseJSON,
								thead, i, i2, $tr, $ul, cnt = 0;

							img.writeAttribute('src', window.dir_images + 'axialis/basic/gear.svg');

							if (!is_json_response(response, true)) {
								return;
							}

							if (!json.success) {
								idoit.Notify.error(json.message);
								return;
							}

							result_table_head.update(new Element('tr'));
							result_table_body.update();

							thead = result_table_head.down('tr');

							for (i in json.data.header) {
								if (json.data.header.hasOwnProperty(i) && i !== 'obj_count') {
									thead.insert(new Element('th').update(json.data.header[i]));
								}
							}

							for (i in json.data.content) {
								if (json.data.content.hasOwnProperty(i)) {

									$tr = new Element('tr', {className:(cnt % 2) ? 'line1' : 'line0'});

									for (i2 in json.data.content[i]) {
										if (json.data.content[i].hasOwnProperty(i2)) {
											$tr.insert(new Element('td').update(json.data.content[i][i2]));
										}
									}

									result_table_body.insert($tr);

									cnt ++;
								}
							}

							cnt = 0;

							result_sum_table.update();

							for (i in json.data.content_sums) {
								if (json.data.content_sums.hasOwnProperty(i)) {

									$tr = new Element('tr', {className:(cnt % 2) ? 'line1' : 'line0'});

									if (typeof json.data.content_sums[i] === 'object') {
										$ul = new Element('ul');
										for (i2 in json.data.content_sums[i]) {
											if (json.data.content_sums[i].hasOwnProperty(i2)) {
												$ul.insert(new Element('li').update(json.data.content_sums[i][i2] + '&times; <strong>' + i2 + '</strong>'));
											}
										}

										$tr
											.update(new Element('td').update(json.data.header[i]))
											.insert(new Element('td').update($ul));
									} else {
										$tr
											.update(new Element('td').update(json.data.header[i]))
											.insert(new Element('td').update(json.data.content_sums[i]));
									}

									result_sum_table.insert($tr);

									cnt ++;
								}
							}
						}
					});
				}
			});
		});
	}());
</script>
