<?php

/**
 * i-doit
 *
 * Module initializer
 *
 * @package     modules
 * @subpackage  analytics
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Psr4AutoloaderClass;

define('C__ANALYTICS__REPORT', 'report');
define('C__ANALYTICS__REPORT_PROFILE', 'profile');

if (isys_module_manager::instance()->is_active('analytics')) {
    Autoloader::appendClassmap(require_once __DIR__ . '/classmap.php');

    if (class_exists(Psr4AutoloaderClass::class)) {
        Psr4AutoloaderClass::factory()
            ->addNamespace('idoit\Module\Analytics', __DIR__ . '/src/');
    }

    isys_application::instance()->container->get('signals')
        ->connect('mod.cmdb.processMenuTreeLinks', ['isys_module_analytics', 'process_menu_tree_links']);

    // @see  ANALYSE-68  Add a route to the dataquality controller.
    isys_request_controller::instance()
        ->addModuleRoute('POST', '/analytics/dataquality/[s:method]', 'analytics', 'Dataquality');
}
