<div id="dataquality-result">
    [{foreach $object_types as $obj_type}]
    [{if $obj_type.obj_count > 0}]
    <div>
        <div class="obj-type-header" data-objtype-id="[{$obj_type.id}]" data-objtype-const="[{$obj_type.const}]">
            <img class="vat mr5" src="[{$obj_type.icon}]" />
            <h2>[{$obj_type.title}]</h2>
            <small class="ml10 text-neutral-600">([{$obj_type.obj_count_string}])</small>

            <button class="btn btn-small btn-secondary ml-auto remove-objtype" type="button" title="[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__REMOVE_OBJECTTYPE"}]" data-tooltip="1">
                <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" />
            </button>
        </div>
        <div class="obj-type-container">

            <table style="width:100%;">
                <tr>
                    <td class="vat" style="width:50%;">
                        <p class="mt5 mb5">
                            <img src="[{$dir_images}]axialis/user-interface/loading.svg" class="animation-rotate mr5 vam" />
                            <span class="vam">[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]</span>
                        </p>
                        <div class="progress">
                            <div class="progress-bar" style="width:0; background-color:transparent;"></div>
                        </div>
                        <div class="detail" style="display:none; position:relative;"></div>
                    </td>
                    <td class="vat" style="width:50%;">
                        <button class="btn disabled toggle-detail mr5" type="button" data-open="0" disabled="disabled">
                            <img src="[{$dir_images}]axialis/user-interface/angle-right-small.svg"><span>[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__SHOW_DETAIL_DATA"}]</span>
                        </button>

                        <button class="btn disabled reset-categories" type="button" disabled="disabled" title="[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__RESET_CATEGORIES_DESCRIPTION"}]">
                            <img src="[{$dir_images}]axialis/basic/symbol-update.svg"><span>[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__RESET_CATEGORIES"}]</span>
                        </button>

                        <div class="detail" style="display:none; position:relative;"></div>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    [{/if}]
    [{/foreach}]
</div>

<div id="profile-configuration" style="display:none;">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__SAVE_AS_NEW_PROFILE"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        <table class="contentTable">
            <tr>
                <td class="key">[{isys type="f_label" name="C__ANALYTICS__PROFILE_NAME" ident="LC_UNIVERSAL__NAME"}]</td>
                <td class="value">[{isys type="f_text" name="C__ANALYTICS__PROFILE_NAME" p_strClass="input-small"}]</td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" name="C__ANALYTICS__PROFILE_USERSPECIFIC" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__USER_SPECIFIC"}]</td>
                <td class="value">[{isys type="f_dialog" name="C__ANALYTICS__PROFILE_USERSPECIFIC" p_strClass="input-small" p_bDbFieldNN=true}]</td>
            </tr>
        </table>
    </div>

    <div class="popup-footer-ng">
        <button type="button" class="btn save mr5"><img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span></button>
        <button type="button" class="btn close"><img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span></button>
    </div>
</div>

<script>
    (function () {
        "use strict";

        var $result_container     = $('dataquality-result'),
            $popup                = $('profile-configuration'),
            $save                 = $('navbar_item_C__NAVMODE__SAVE'),
            $save_as              = $('navbar_item_C__NAVMODE__SAVE_AS'),
            $publish              = $('navbar_item_publish'),
            $purge                = $('navbar_item_purge_profile'),
            $object_type_reset    = $('navbar_item_reset'),
            dataquality_instances = {},
            isReportProfile       = '[{$isReportProfile|json_encode|escape:"javascript"}]'.evalJSON(),
            reportId              = '[{$reportId|json_encode|escape:"javascript"}]'.evalJSON(),
            categories            = '[{$categories|json_encode|escape:"javascript"}]'.evalJSON();

        $('popup').update($popup.show());

        // Include the dataquality class.
        [{include file="`$analyticsPath`reports/js/dataquality.js"}]

        /*
         * This is the initial loop to create all "DataQuality" instances.
         */
        $result_container.select('div.obj-type-container').each(function ($el) {
            dataquality_instances[$el.previous('[data-objtype-const]').readAttribute('data-objtype-const')] = new DataQuality($el, {
                categories: categories
            });
        });

        /*
         * The "remove object type" action will filter a given object type from the current profile.
         */
        $result_container.on('click', 'button.remove-objtype', function (ev) {
            var $button           = ev.findElement('button'),
                object_type_const = $button.up('[data-objtype-const]').readAttribute('data-objtype-const');

            new Effect.BlindUp($button.up('div'), {
                duration:    0.5,
                afterFinish: function (effect) {
                    delete dataquality_instances[object_type_const];
                    effect.element.remove();
                }
            });
        });

        /*
         * "collect_data" function for collecting all "object-type <-> category" configurations in a clean format.
         */
        var collect_data = function () {
            var data = {},
                object_type_const,
                category_const;

            if (isReportProfile && reportId) {
                data.reportId = reportId;
            }

            for (object_type_const in dataquality_instances) {
                if (dataquality_instances.hasOwnProperty(object_type_const)) {
                    if (Object.isUndefined(data[object_type_const])) {
                        data[object_type_const] = [];
                    }

                    for (category_const in dataquality_instances[object_type_const].data) {
                        if (dataquality_instances[object_type_const].data.hasOwnProperty(category_const)) {
                            data[object_type_const].push(category_const);
                        }
                    }
                }
            }

            return data;
        };

        /*
         * "Save" action (navbar) for saving the current configuration (may call "Save as" action).
         */
        if ($save) {
            $save.writeAttribute('onclick', null).on('click', function () {
                if ('[{$profile_id}]' > 0) {
                    new Ajax.Request('[{$ajax_url}]&func=save-profile&[{$smarty.const.C__ANALYTICS__REPORT_PROFILE}]=[{$profile_id}]', {
                        parameters: {
                            data: Object.toJSON(collect_data())
                        },
                        onComplete: function (response) {
                            var json = response.responseJSON;

                            if (!is_json_response(response, true)) {
                                return;
                            }

                            if (!json.success) {
                                idoit.Notify.error(json.message);
                                return;
                            }

                            window.location.reload();
                        }
                    });
                } else {
                    if ($save_as) {
                        $save_as.simulate('click');
                    } else {
                        popup_open('popup', 640, 250);
                    }
                }
            });
        }

        /*
         * "Save as" action (navbar) for opening a small popup and save the current configuration as a new profile.
         */
        if ($save_as) {
            $save_as.on('click', function () {
                popup_open('popup', 640, 250);
            });
        }

        /*
         * "Close" action (popup) for closing the "Save as" popup.
         */
        $popup.on('click', '.close', function () {
            popup_close();
        });

        /*
         * "Save" action (popup) for saving the current configuration as a new profile.
         */
        $popup.on('click', '.save', function (ev) {
            ev.findElement('button')
                .down('img').addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg')
                .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

            new Ajax.Request('[{$ajax_url}]&func=save-profile-as', {
                parameters: {
                    data:          Object.toJSON(collect_data()),
                    title:         $F('C__ANALYTICS__PROFILE_NAME'),
                    user_specific: $F('C__ANALYTICS__PROFILE_USERSPECIFIC')
                },
                onComplete: function (response) {
                    var json = response.responseJSON;

                    if (!is_json_response(response, true)) {
                        return;
                    }

                    if (!json.success) {
                        idoit.Notify.error(json.message);
                        return;
                    }

                    idoit.Notify.success('[{isys type="lang" ident="LC__INFOBOX__DATA_WAS_SAVED"}]');

                    window.location.href = json.data;
                }
            });
        });

        /*
         * "Reset" action (navbar) for displaying all previously filtered object types.
         */
        if ($object_type_reset) {
            $object_type_reset.on('click', function (ev) {
                ev.findElement('.btn').down('img')
                    .addClassName('animation-rotate')
                    .writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

                window.location.href = window.location.href + '&reset=all';
            });
        }

        /*
         * "Publish" action (navbar) for publishing a user specific profile for all.
         */
        if ($publish) {
            $publish.on('click', function () {
                if (confirm('[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__MAKE_PUBLIC_CONFIRM" p_bHtmlEncode=false}]')) {
                    $publish.down('img').addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

                    new Ajax.Request('[{$ajax_url}]&func=publish-profile', {
                        onComplete: function (response) {
                            var json = response.responseJSON;

                            if (!is_json_response(response, true)) {
                                return;
                            }

                            if (!json.success) {
                                idoit.Notify.error(json.message);
                                return;
                            }

                            idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__MAKE_PUBLIC_NOTIFY"}]');

                            $publish.remove();
                        }
                    });
                }
            });
        }

        /*
         * "Purge" action (navbar) for deleting a profile permanently.
         */
        if ($purge) {
            $purge.on('click', function () {
                if (confirm('[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__PURGE_CONFIRM" p_bHtmlEncode=false}]')) {
                    new Ajax.Request('[{$ajax_url}]&func=delete-profile', {
                        onComplete: function (response) {
                            var json = response.responseJSON;

                            if (!is_json_response(response, true)) {
                                return;
                            }

                            if (!json.success) {
                                idoit.Notify.error(json.message);
                                return;
                            }

                            idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__MAKE_PUBLIC_NOTIFY"}]');

                            document.location.href = json.data;
                        }
                    });
                }
            });
        }
    }());
</script>

<style type="text/css">
    #dataquality-result {
        background: #fff;
    }

    #dataquality-result > div {
        border-top: 1px solid #888;
    }

    #dataquality-result > div:first-child {
        border-top: none;
    }

    #dataquality-result .obj-type-header {
        background-color: #eee;
        display: flex;
        align-items: center;
        padding: 5px;
        border-bottom: 1px solid #888;
    }

    #dataquality-result .object-table {
        margin-top: 15px;
    }

    #dataquality-result .object-table > div {
        padding: 5px;
        border-top: 1px solid #888;
        border-left: 1px solid #888;
        border-right: 1px solid #888;
        display: flex;
        align-items: center;
    }

    #dataquality-result h3 {
        padding: 5px;
        border-top: 1px solid #888;
        border-bottom: 1px solid #888;
    }

    #dataquality-result div:first-child h3 {
        border-top-width: 0;
    }

    #dataquality-result h3 button {
        margin-top: -2px;
    }

    #dataquality-result div.obj-type-container {
        margin: 5px 5px 15px;
    }

    .obj-type-container td:first-child {
        padding-right: 15px;
    }

    #dataquality-result h3 img {
        max-width: 16px;
        max-height: 16px;
    }

    .detail .progress,
    .detail .progress-bar {
        height: 3px;
    }

    #dataquality-result svg text {
        font-size: 15px;
    }

    #dataquality-result svg .arc {
        transition: opacity 500ms;
        -moz-transition: opacity 500ms;
        -webkit-transition: opacity 500ms;
    }

    #dataquality-result svg .filtered {
        opacity: 0.25;
    }
</style>
