<fieldset class="overview">
	<legend class="border-top-none">[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS"}]</legend>
	<div class="p5 mt10">
		<p class="mb5">[{isys type="lang" ident="LC__MODULE__ANALYTICS__OBJECT_CATALOG__OBJECT_SELECTION"}]</p>

		<table class="contentTable" style="padding-top:0;">
			<tr>
				<td class="key">[{isys type="f_label" name="impact_obj_selection" ident="LC__MODULE__ANALYTICS__FAIL_SIMULATION__OBJECT_LABEL"}]</td>
				<td class="value">[{isys name="obj_catalog_selection" type="f_popup" p_strPopupType="browser_object_ng"}]</td>
			</tr>
			<tr>
				<td class="key vat">[{isys type="f_label" name="impact_itservice_filter" ident="LC__MODULE__ANALYTICS__FILTERS"}]</td>
				<td class="value">
					[{isys name="impact_itservice_filter" type="f_dialog" p_strClass="input-small"}]
					<br class="cb" />
					<p class="ml20 text-neutral-400 mb5">[{$filter_description}]</p>
				</td>
			</tr>
		</table>
	</div>
</fieldset>

<fieldset class="overview" style="margin-top: 15px; background:#f5f5f5;">
	<legend><span>[{isys type="lang" ident="LC__MODULE__ANALYTICS__RESULT"}]</span></legend>
</fieldset>

<div id="results" class="p5 pt10">

</div>

<script>
	(function () {
		"use strict";

		var $trigger = $('navbar_item_calculation'),
			$result_container = $('results'),
			colors = {
				C__CATS__LICENCE: '#3498db',
				C__CATG__ACCOUNTING_price: '#9b59b6',
				C__CATG__ACCOUNTING_yearly: '#2ecc71',
				C__CATG__CONTRACT_ASSIGNMENT: '#e74c3c'},
			misc,
			currency = '[{$currency}]';

		$trigger.on('click', function (ev) {
			var itservice_obj = $F('obj_catalog_selection__HIDDEN'),
				img = ev.findElement('button').down('img');

			if ($trigger.retrieve('running', false)) {
				return;
			}

			$trigger.store('running', true);

			if (itservice_obj.blank()) {
				idoit.Notify.warning('[{isys type="lang" ident="LC__MODULE__ANALYTICS__NOTIFY__NO_IMPACT_OBJECT"}]', {life: 5});
				return;
			}

			img.addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

			$result_container
				.update(new Element('img', {className:'vam mr5 animation-rotate', src:window.dir_images + 'axialis/user-interface/loading.svg'}))
				.insert(new Element('span', {className:'vam'}).update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]'));

			new Ajax.Request('[{$ajax_url}]&func=start-calculation', {
				parameters: {
					filter: $F('impact_itservice_filter'),
					itservice_obj: itservice_obj
				},
				onComplete: function (response) {
					var json = response.responseJSON;

					$trigger.store('running', false);

					if (!is_json_response(response, true)) {
						img.removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/basic/gear.svg');
						return;
					}

					if (!json.success) {
						img.removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/basic/gear.svg');
						idoit.Notify.error(json.message);
						return;
					}

					idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__ANALYTICS__OBJECT_CATALOG__FOUND_X_OBJECTS"}]'.replace('%d', json.data.length), {life:5});

					new Ajax.Request('[{$ajax_url}]&func=calculate-costs', {
						parameters: {
							obj_ids: Object.toJSON(json.data)
						},
						onComplete: function (response) {
							var json = response.responseJSON,
								$table, $thead, $tbody, $tr,
								category, row, cnt, i, i2, last_object = 0, rowspan = 1;

							$result_container.update();
							img.removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/basic/gear.svg');

							if (!is_json_response(response, true)) {
								return;
							}

							if (!json.success) {
								idoit.Notify.error(json.message);
								return;
							}

							misc = json.data.misc;

							currency = misc.currency;

							// At first display the table which displays the direct costs of each category.
							$table = new Element('table', {id:'result_table_categories', className:'mainTable border-left border-right border-bottom mb15', cellpadding:0, cellspacing:0});
							$thead = new Element('thead')
								.update(new Element('tr')
									.update(new Element('th', {className:'check'}))
									.insert(new Element('th').update('[{isys type="lang" ident="LC_UNIVERSAL__CATEGORY"}]'))
									.insert(new Element('th').update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS__DOCUMENTED_COSTS"}]')));
							$tbody = new Element('tbody');

							cnt = 0;

							for (category in misc.category_costs) {
								if (misc.category_costs.hasOwnProperty(category) && category !== 'C__CATG__ACCOUNTING') {
									$tbody
										.insert(new Element('tr', {className:(cnt % 2 ? 'line0' : 'line1'), 'data-category':category})
											.update(new Element('td', {className:'check'}).update(new Element('input', {type:'checkbox', className:'checkbox'})))
											.insert(new Element('td').update(misc.categories[category].title))
											.insert(new Element('td', {style:'text-align:right;'}).update(format_output_syntax('$', misc.category_costs[category]))));
								}

								cnt ++;
							}

							$tbody
								.insert(new Element('tr', {className:'text-bold last on'}));

							$result_container
								.insert(new Element('h3', {className:'bg-neutral-200 border p5 mt10'}).update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS__OVERVIEW"}]'))
								.insert($table.update($thead).insert($tbody));

							// At first display the table which displays the direct costs of each category.
							$table = new Element('table', {id:'result_table_misc', className:'mainTable border-left border-right border-bottom mb15', cellpadding:0, cellspacing:0});
							$thead = new Element('thead')
								.update(new Element('tr')
									.insert(new Element('th').update('[{isys type="lang" ident="LC_UNIVERSAL__CATEGORY"}]'))
									.insert(new Element('th').update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS__DOCUMENTED_VALUES"}]')));
							$tbody = new Element('tbody');

							cnt = 0;

							for (category in misc.category_misc) {
								if (misc.category_misc.hasOwnProperty(category) && category !== 'C__CATG__ACCOUNTING') {
									$tbody
										.insert(new Element('tr', {className:(cnt % 2 ? 'line0' : 'line1'), 'data-category':category})
											.insert(new Element('td').update(misc.categories[category].title))
											.insert(new Element('td', {style:'text-align:right;'}).update(format_output_syntax('W', misc.category_misc[category]))));
								}

								cnt ++;
							}

							$result_container
								.insert(new Element('h3', {className:'bg-neutral-200 border p5 mt10'}).update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS__MISC_OVERVIEW"}]'))
								.insert($table.update($thead).insert($tbody))
								.insert(new Element('div', {id:'chart_overview', className:'box-white'}));

							update_overview_table();
							draw_chart();

							// Now add the category specific tables.
							for (category in json.data.categories) {
								if (json.data.categories.hasOwnProperty(category)) {
									$table = new Element('table', {id:'result_table__' + category, className:'mainTable border-left border-right border-bottom', cellpadding:0, cellspacing:0});
									$thead = new Element('thead', {className:'hide'});
									$tbody = new Element('tbody');
									$tr = new Element('tr');

									last_object = 0;

									for (i in json.data.categories[category].header) {
										if (json.data.categories[category].header.hasOwnProperty(i)) {
											$tr.insert(new Element('th', {style:(i>0) ? 'text-align:right;' : 'text-align:left;'}).update(json.data.categories[category].header[i]));
										}
									}

									$thead.update($tr);
									cnt = 0;

									for (i in json.data.categories[category].content) {
										if (json.data.categories[category].content.hasOwnProperty(i)) {
											row = json.data.categories[category].content[i];

											$tr = new Element('tr', {className:'hide ' + (cnt % 2 ? 'line0' : 'line1')});

											for (i2 in row) {
												if (row.hasOwnProperty(i2)) {
													try {
														if (i2 === '_object_' && row[i2] === last_object) {
															rowspan ++;

															continue;
														} else if (i2 === '_object_' && row[i2] !== last_object && rowspan > 1) {
															if ($tbody.down('td[data-object-id="' + last_object + '"]')) {
																$tbody.down('td[data-object-id="' + last_object + '"]').writeAttribute('rowspan', rowspan);
															}

															rowspan = 1;
														} else {
														}

														$tr.insert(new Element('td', {style:'text-align:' + (i2=='_object_'?'left':'right')}).update(format_output_syntax(i2, row[i2])));

														if (i2 === '_object_') {
															$tr.down('td').writeAttribute('data-object-id', row[i2]);

															last_object = row[i2];
														}
													} catch (e) {
														$tr.insert(new Element('td', {style:'text-align:' + (i2=='_object_'?'left':'right'), className:'red'}).update(e.message));
													}
												}
											}

											if (rowspan > 1) {
												if ($tbody.down('td[data-object-id="' + last_object + '"]')) {
													$tbody.down('td[data-object-id="' + last_object + '"]').writeAttribute('rowspan', rowspan);
												}
											}

											cnt ++;

											$tbody.insert($tr);
										}
									}

									if (misc.category_costs.hasOwnProperty(category)) {
										$tbody
											.insert(new Element('tr', {className:'text-bold on'})
												.update(new Element('td', {className:'border-top', colspan:2}).update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS__SUMMED"}]'))
												.insert(new Element('td', {className:'border-top', style:'text-align:right;'}).update(format_output_syntax('$', misc.category_costs[category]))))
									} else if (category === 'C__CATG__POWER_CONSUMER') {
										$tbody
											.insert(new Element('tr', {className:'text-bold on'})
												.update(new Element('td', {className:'border-top', colspan:2}).update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS__SUMMED"}]'))
												.insert(new Element('td', {className:'border-top', style:'text-align:right;'}).update(misc.total_watt)))
									}

									$result_container
										.insert(new Element('h3', { className:'bg-neutral-200 border p5 mt15'})
											.update(new Element('button', { className:'btn mr5', type:'button', 'data-open':0})
                                                .update(new Element('img', { src: window.dir_images + 'axialis/user-interface/angle-right-small.svg'})))
											.insert(new Element('span').update(misc.categories[category].title))
											.insert(new Element('small', { className:'text-neutral-400 ml15'})
                                                .update('(' + misc.categories[category].count + (misc.categories[category].count == 1 ? ' [{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__CATEGORY_CONTENT"}])' : ' [{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__CATEGORY_CONTENTS"}])'))))
										.insert($table.update($thead).insert($tbody));
								}
							}
						}
					});
				}
			});
		});

		/*
		 * Function for formatting the output, retrieved via ajax (see the short description in "isys_analytics_reports_servicecosts").
		 */
		var format_output_syntax = function (key, value) {
			var i, val = value;

			if (key == '_object_') {
				return new Element('span')
					.update(new Element('img', {className:'vam mr5', src:misc.objects[value].type_icon, title:misc.objects[value].type_title}))
					.insert(new Element('span', {className:'vam'}).update(misc.objects[value].title));
			}

			if (key.substr(0, 1) === '$') {
				// We have a "money" value, so we do some extra work here.
				return parseFloat(val || 0).toFixed(2) + ' ' + currency;
			} else if (key.substr(0, 1) === '+') {
				// We have a "dialog+" value.
				return val['title'];
			} else if (key.substr(0, 1) === 'W') {
				// We have a "WATT" value, so we do some extra work here.
				return parseFloat(val || 0).toFixed(2) + ' W';
			}

			if (typeof value === 'object') {
				val = '';

				for (i in value) {
					if (value.hasOwnProperty(i)) {
						if (i === '()') {
							val += '(' + format_output_syntax(i, value[i]).strip() + ')'
						} else {
							val += format_output_syntax(i, value[i]) + ' ';
						}
					}
				}
			}

			return val;
		};

		/*
		 * Function for updating the "summed up" category result.
		 */
		var update_overview_table = function () {
			var $rows = $('result_table_categories').select('tbody tr'),
				costs = 0, i;

			for (i in $rows) {
				if ($rows.hasOwnProperty(i) && !$rows[i].hasClassName('last') && !$rows[i].down('.opacity-30')) {
					costs += misc.category_costs[$rows[i].readAttribute('data-category')];
				}
			}

			$rows.last()
				.update(new Element('td', {className:'border-top check'}))
				.insert(new Element('td', {className:'border-top'}).update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS__SUMMED"}]'))
				.insert(new Element('td', {className:'border-top', style:'text-align:right;'}).update(format_output_syntax('$', costs)));
		};

		/*
		 * Function for drawing the pie chart.
		 */
		var draw_chart = function () {
			var $container = $('chart_overview'),
				$rows = $('result_table_categories').select('tbody tr'),
				width = ($container.getWidth() - 100),
			    dataCache = [],
				category, i;

			if (width > 700) {
				width = 700;
			}

            idoit.Require.require(['d3', 'd3ChartPie'], function () {
			    for (i in $rows) {
                    if ($rows.hasOwnProperty(i) && !$rows[i].hasClassName('last') && !$rows[i].down('.opacity-30')) {
                        category = $rows[i].readAttribute('data-category');

                        dataCache.push({
                            id:    category,
                            count: misc.category_costs[category],
                            color: colors[category],
                            label: parseFloat(misc.category_costs[category] || 0).toFixed(2) + ' ' + currency
                        });
                    }
			    }

			    new D3ChartPie($container, {width: width, height: 450}).setData(dataCache).update();

			    $container.insert(new Element('p', {className:'m5'}).update('[{isys type="lang" ident="LC__MODULE__ANALYTICS__SERVICECOSTS__CHART_MONEY_UNIT_DESCRIPTION"}]'.replace('%s', '[{$currency}]')));
            });
		};

		/*
		 * Callback for filtering categories out of the calculation and chart.
		 */
		$result_container.on('change', 'input.checkbox', function (ev) {
			var $checkbox = ev.findElement('input'),
				$row = $checkbox.up('tr');

			$row.select('td:not(:first-child)').invoke('toggleClassName', 'opacity-30');

			update_overview_table();
			draw_chart();
		});

		$result_container.on('click', 'h3 button', function (ev) {
			var $button = ev.findElement('button'),
				$table = $button.up('h3').next('table');

			if ($button.readAttribute('data-open') == 0) {
				$button.writeAttribute('data-open', 1).down('img').writeAttribute('src', window.dir_images + 'axialis/user-interface/angle-down-small.svg');
			} else {
				$button.writeAttribute('data-open', 0).down('img').writeAttribute('src', window.dir_images + 'axialis/user-interface/angle-right-small.svg');
			}

			$table.select('.hide,.no-hide').invoke('toggleClassName', 'hide').invoke('toggleClassName', 'no-hide');
		});
	}());
</script>

<style type="text/css">
	#results th:first-child,
	#results td:first-child {
		width: 200px;
	}

	#results th.check,
	#results td.check {
		width: 25px;
		text-align: center;
	}

	#results td img {
		max-width:16px;
		max-height:16px;
	}

	#chart_overview svg text {
		font-size: 15px;
	}

	#chart_overview svg .arc {
		transition: opacity 500ms;
		-moz-transition: opacity 500ms;
		-webkit-transition: opacity 500ms;
	}

	#chart_overview svg .filtered {
		opacity: 0.25;
	}
</style>
