<div id="popup-analytics-profiles">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__MANAGE_PROFILES_DESCRIPTION"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content" id="popup-analytics-profiles-content">
        <!-- Will be filled by JS -->
    </div>

    <div class="popup-footer-ng">
        <button type="button" class="btn">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_SAVE"}]</span>
        </button>

        <button type="button" class="btn ml5 popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        const $popup = $('popup-analytics-profiles');
        const objectTypes = JSON.parse('[{$objectTypes|json_encode|escape:"javascript"}]')

        $popup.on('click', '.popup-closer', function () {
            popup_close();
        });

        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__CHECK_REPORT', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__CHECK_REPORT" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__REPORT_COMPATIBLE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__REPORT_COMPATIBLE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__REPORT_INCOMPATIBLE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__REPORT_INCOMPATIBLE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__ADD_NEW_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__ADD_NEW_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__EDIT_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__EDIT_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__RENAME_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__RENAME_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__DELETE_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__DELETE_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__DUPLICATE_PROFILE', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__DUPLICATE_PROFILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__OBJECT_TYPES', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__OBJECT_TYPES" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__CATEGORIES', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__CATEGORIES" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__REPORT_PRE_FILTER', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__REPORT_PRE_FILTER" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__ANALYTICS__DATA_QUALITY__PURGE_CONFIRM', '[{isys type="lang" ident="LC__MODULE__ANALYTICS__DATA_QUALITY__PURGE_CONFIRM" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__CMDB__LIST_LOAD_ALL', '[{isys type="lang" ident="LC__CMDB__LIST_LOAD_ALL" p_bHtmlEncode=false}]');

        idoit.Require.addModule('analytics.profile-manager', '[{$assetsWwwDir}]js/profile-manager.js');

        idoit.Require.require('analytics.profile-manager', function () {
            const profileManager = new ProfileManager($('popup-analytics-profiles-content'), {
                objectTypes: objectTypes
            });

            $popup.down('.popup-footer-ng button').on('click', function () {
                new Ajax.Request(window.www_dir + 'analytics/dataquality/saveProfiles', {
                    parameters: {
                        data: JSON.stringify(profileManager.getProfiles()),
                        deletedData: JSON.stringify(profileManager.getDeletedProfiles())
                    },
                    onComplete: function (xhr) {
                        var json = xhr.responseJSON;

                        if (json.success) {
                            popup_close();
                            idoit.Notify.success('[{isys type="lang" ident="LC__INFOBOX__DATA_WAS_SAVED"}]', {sticky: true});
                            document.location.reload(true);
                        } else {
                            idoit.Notify.error(json.message, {sticky: true});
                        }
                    }
                });
            });
        });
    })();
</script>

<style type="text/css">
    #popup-analytics-profiles-content {
        display: flex;
        justify-content: space-between;
        align-items: stretch;
    }

    #popup-analytics-profiles-content * {
        box-sizing: border-box;
        user-select: none;
    }

    #popup-analytics-profiles-content .overlay {
        position: absolute;
        background-color: rgba(255, 255, 255, .8);
        top: 0;
        right: 0;
        bottom: 0;
        left: 230px;
    }

    #popup-analytics-profiles-content > div {
        flex: 1 1 auto;
        position: relative;
    }

    #popup-analytics-profiles-content > div:first-child {
        width: 25%;
        max-width: 25%;
        margin-right: 20px;
    }

    #popup-analytics-profiles-content > div:last-child {
        width: 75%;
        max-width: 75%;
    }

    #popup-analytics-profiles-content .list {
        margin: 0;
        padding: 0;
        list-style: none;
        height: 420px;
        overflow-y: auto;
    }

    #popup-analytics-profiles-content .list li {
        border-bottom: 1px solid #aaa;
        padding: 5px;
        position: relative;
        transition: background-color 150ms;
        display: flex;
        align-items: center;
    }

    #popup-analytics-profiles-content .list li.active {
        background-color: #eee;
    }

    #popup-analytics-profiles-content .list li.not-selected {
        background-color: #f5f5f5;
    }

    #popup-analytics-profiles-content .list li:hover {
        background-color: #e0e0e0;
    }

    #popup-analytics-profiles-content .list li input {
        position: absolute;
        top: 10px;
        left: 8px;
    }

    #popup-analytics-profiles-content .list li span {
        margin-left: 25px;
    }

    #popup-analytics-profiles-content .list li span,
    #popup-analytics-profiles-content .list li strong {
        line-height: 25px;
        display: block;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    #popup-analytics-profiles-content .list li button {
        opacity: 0;
        transition: opacity 150ms;
    }

    #popup-analytics-profiles-content .list li:hover button {
        opacity: 1;
    }

    #popup-analytics-profiles-content .configuration-content {
        position: absolute;
        top: 50px;
        right: 0;
        bottom: 0;
        left: 0;
        border-right: none;
        border-bottom: none;
        display: flex;
        flex: 1 1 auto;
    }

    #popup-analytics-profiles-content .configuration-content .list {
        height: 372px;
    }

    #popup-analytics-profiles-content .configuration-content > div:not(.overlay) {
        width: 50%;
        overflow: none;
        overflow-y: auto;
    }
</style>
