<?php

/**
 * i-doit
 *
 * Analysis API model.
 *
 * @package    i-doit
 * @subpackage analytics
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_analysis extends isys_api_model implements isys_api_model_interface
{
    /**
     * @param string $method
     * @param array  $parameters
     *
     * @return $this|isys_api_model
     * @throws Exception
     */
    public function route($method, $parameters)
    {
        if ($method !== 'dataquality') {
            throw new Exception('Method "analysis.' . $method . '" does not exist.');
        }

        $option = $parameters['option'] ?: 'read';

        if (!in_array($option, ['read', 'profiles'], true)) {
            throw new Exception('The model "dataquality" does not contain a "' . $option . '" method.');
        }

        $model = new isys_api_model_analysis_dataquality();
        $this->m_data = call_user_func([$model, $option], $parameters);

        return $this;
    }

    /**
     * @param array $parameters
     *
     * @return mixed|null
     */
    public function read($parameters)
    {
        return null;
    }
}
