<?php

/**
 * i-doit
 *
 * Abstract report class.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.3
 */
abstract class isys_analytics_reports
{
    /** @var isys_component_database */
    protected isys_component_database $database;

    /** @var isys_component_template  */
    protected isys_component_template $template;

    /** @var isys_component_template_language_manager */
    protected isys_component_template_language_manager $language;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->database = isys_application::instance()->container->get('database');
        $this->template = isys_application::instance()->container->get('template');
        $this->language = isys_application::instance()->container->get('language');
    }

    /**
     * Method for preparing the visual report view output.
     *
     * @return isys_analytics_reports
     */
    abstract public function start();

    /**
     * This method will be called by the framework, to process ajax requests.
     * It should echo a string and then terminate the request (via "die;").
     */
    abstract public function ajax_request();

    /**
     * Returns the reports title via late static binding.
     *
     * @return  string
     */
    public function getTitle(): string
    {
        return static::TITLE;
    }

    /**
     * Returns the reports icon via late static binding.
     *
     * @return  string
     */
    public function getIcon(): string
    {
        return static::ICON;
    }

    /**
     * @return bool
     */
    public function displayInNavigation(): bool
    {
        return true;
    }

    /**
     * @param isys_component_tree $tree
     * @param int                 $parent
     *
     * @return void
     */
    public function buildNavigation(isys_component_tree $tree, int $parent): void
    {

    }

    /**
     * @param array $gets
     *
     * @return array|null
     */
    public function getBreadcrumbItems(array $gets): ?array
    {
        return null;
    }
}
