<?php

namespace idoit\Module\Analytics\Helper;

use isys_module_analytics as ModuleAnalytics;

/**
 * i-doit
 *
 * Simulation helper class.
 *
 * @package    idoit\Module\Analytics\Helper
 * @author     Leonard Fischer <lfischer@i-doit.com>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class Simulation
{
    /**
     * Retrieve all simulation instances.
     *
     * @return \isys_analytics_reports[]
     */
    public static function getAll()
    {
        $return = [];
        $reportClasses = glob(ModuleAnalytics::getPath() . 'reports/*.class.php');

        // Here we create a menu item for each found report.
        foreach ($reportClasses as $reportClass) {
            $reportClass = basename($reportClass, '.class.php');

            if ($reportClass !== 'isys_analytics_reports' && class_exists($reportClass) && is_a($reportClass, 'isys_analytics_reports', true)) {
                $reportInstance = new $reportClass();

                if (!$reportInstance->displayInNavigation()) {
                    continue;
                }

                $return[$reportClass] = $reportInstance;
            }
        }

        return $return;
    }
}
