<?php

namespace idoit\Module\Analytics\Model;

use idoit\Model\Dao\Base;
use isys_analytics_reports_dataquality;
use isys_application;
use isys_cmdb_dao_category;
use isys_component_dao_result;
use isys_format_json as JSON;

/**
 * Class Util
 *
 * @package idoit\Module\Analytics\Model
 */
class Util extends Base
{
    /**
     * @param string $objectTypeConstant
     *
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getCategoriesByObjectType(string $objectTypeConstant): isys_component_dao_result
    {
        $sql = 'SELECT isys_obj_type__id AS id
            FROM isys_obj_type
            WHERE isys_obj_type__const = ' . $this->convert_sql_text($objectTypeConstant) . '
            LIMIT 1';

        $objectTypeId = $this->convert_sql_id($this->retrieve($sql)->get_row_value('id'));

        $sql = "SELECT isysgui_catg__title AS title, isysgui_catg__const AS const, 'LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__TYPE_GLOBAL' AS type  
            FROM isysgui_catg 
            INNER JOIN isys_obj_type_2_isysgui_catg ON isys_obj_type_2_isysgui_catg__isysgui_catg__id = isysgui_catg__id
            WHERE isys_obj_type_2_isysgui_catg__isys_obj_type__id = {$objectTypeId}
            
            UNION
            
            SELECT isysgui_catg_custom__title AS title, isysgui_catg_custom__const AS const, 'LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__TYPE_CUSTOM' AS type
            FROM isysgui_catg_custom 
            INNER JOIN isys_obj_type_2_isysgui_catg_custom ON isys_obj_type_2_isysgui_catg_custom__isysgui_catg_custom__id = isysgui_catg_custom__id
            WHERE isys_obj_type_2_isysgui_catg_custom__isys_obj_type__id  = {$objectTypeId}
            
            UNION

            SELECT isysgui_cats__title AS title, isysgui_cats__const AS const, 'LC__MODULE__ANALYTICS__DATA_QUALITY_PROFILES__TYPE_SPECIFIC' AS type
            FROM isysgui_cats 
            INNER JOIN isys_obj_type ON isys_obj_type__isysgui_cats__id = isysgui_cats__id
            WHERE isys_obj_type__id  = {$objectTypeId};";

        return $this->retrieve($sql);
    }

    /**
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getObjectTypes(): isys_component_dao_result
    {
        // Prepare blacklist.
        $objectTypeConstants = implode(',', array_map(function($constant) {
            return $this->convert_sql_text($constant);
        }, isys_analytics_reports_dataquality::OBJECT_TYPE_BLOCKLIST));

        $sql = "SELECT isys_obj_type__title AS title, isys_obj_type__const AS const
            FROM isys_obj_type
            WHERE isys_obj_type__const NOT IN ({$objectTypeConstants});";

        return $this->retrieve($sql);
    }

    /**
     * Get all global and specific categories that should not be processed.
     *
     * @return \string[][]
     * @throws \Exception
     */
    public function getBlockedCategories(): array {
        $categoryBlocklist = [
            'g' => [
                'C__CATG__LOGBOOK',
                'C__CATG__IMAGE',
                'C__CATG__OVERVIEW',
                'C__CATG__OBJECT',
                'C__CATG__CLUSTER_ROOT',
                'C__CATG__CLUSTER',
                'C__CATG__CLUSTER_SHARED_STORAGE',
                'C__CATG__CLUSTER_VITALITY',
                'C__CATG__VIRTUAL_HOST_ROOT',
                'C__CATG__CLUSTER_SHARED_VIRTUAL_SWITCH',
                'C__CATG__ITS_LOGBOOK',
                'C__CATG__OBJECT_VITALITY',
                'C__CATG__RELATION',
                'C__CATG__NETWORK_PORT_OVERVIEW',
                'C__CATG__VIRTUAL_TICKETS',
                'C__CATG__RACK_VIEW',
                'C__CATG__LIVESTATUS',
                'C__CATG__NET_CONNECTIONS_FOLDER',
                'C__CATG__NDO',
                'C__CATG__VIRTUAL_AUTH'
            ],
            's' => [
                'C__CATS__PRT',
                'C__CATS__FILE',
                'C__CATS__LICENCE'
            ]
        ];

        // Array of categories that should not be skipped (even though they qualify as 'skippable').
        $shouldNotSkip = [
            'C__CATG__IT_SERVICE' // @see ANALYSE-76
        ];

        $cmdbDao = isys_application::instance()->container->get('cmdb_dao');

        $condition = $this->prepare_in_condition([isys_cmdb_dao_category::TYPE_VIEW, isys_cmdb_dao_category::TYPE_REAR]);

        // IMPORTANT: We do not use '$cmdbDao->get_all_categories' here, because that returns different results when called more than once.
        $query = "SELECT isysgui_catg__const AS const, 'g' AS type
            FROM isysgui_catg
            WHERE isysgui_catg__type {$condition}
            
            UNION
            
            SELECT isysgui_cats__const AS const, 's' AS type
            FROM isysgui_cats
            WHERE isysgui_cats__type {$condition};";

        $result = $this->retrieve($query);

        while ($row = $result->get_row()) {
            if (in_array($row['const'], $shouldNotSkip, true)) {
                continue;
            }

            $categoryBlocklist[$row['type']][] = $row['const'];
        }

        return $categoryBlocklist;
    }
}
