<?php

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Exception\JsonRpc\ParameterException;
use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;

/**
 * Class AssignedSubscriptionsProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class AssignedSubscriptionsProcessor extends AbstractCategoryProcessor implements RequestModifier
{
    /**
     * Modify api request
     *
     * @param array $request
     *
     * @return array
     * @throws ParameterException
     */
    public function modifyRequest(array $request)
    {
        // Check whether requested option is equal to read
        if ($request['option'] === 'read') {
            return $request;
        }

        // Initialize needed data
        $uuid = $request['data']['uuid'];
        $assignedObject = $request['data']['assigned_object'];
        $subscriptionsDao = \isys_cmdb_dao_category_g_cloud_subscriptions::instance(\isys_application::instance()->container->get('database'));

        // Check whether processing is necessary or not
        if (empty($uuid) || empty($assignedObject)) {
            return $request;
        }

        // Check whether creation is requested without setted manufacturer but title
        if ($request['option'] === 'create') {
            throw new ParameterException('Cannot set uuid without specified assigned Object.');
        }

        $subscriptions = $subscriptionsDao->get_data(null, $assignedObject);

        $request['data']['uuid'] = null;
        while ($row = $subscriptions->get_row()) {
            if (!is_int($uuid) && $row['isys_catg_cloud_subscriptions_list__uuid'] === $uuid) {
                $request['data']['uuid'] = $row['isys_catg_cloud_subscriptions_list__id'];
                break;
            }
            if (is_int($uuid) && (int) $row['isys_catg_cloud_subscriptions_list__id'] === $uuid) {
                $request['data']['uuid'] = $row['isys_catg_cloud_subscriptions_list__id'];
                break;
            }
        }

        return $request;
    }
}