<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;
use isys_application;
use isys_cmdb_dao_category_g_location;
use isys_exception_api_validation;

/**
 * Class LocallyAssignedObjectsProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class LocallyAssignedObjectsProcessor extends AbstractCategoryProcessor implements RequestModifier
{
    /**
     * Modify api request.
     *
     * @param array $request
     *
     * @return array
     * @throws \isys_exception_database
     * @throws isys_exception_api_validation
     */
    public function modifyRequest(array $request)
    {
        if (array_key_exists('objID', $request) && is_numeric($request['objID']) && isset($request['data']['assigned_object'])) {
            $locationDao = \isys_cmdb_dao_category_g_location::instance(\isys_application::instance()->container->get('database'));
            $parent = $locationDao->get_data(null, $request['objID'])->get_row_value('isys_catg_location_list__parentid');

            if (!is_numeric($parent) && $parent > 0) {
                throw new isys_exception_api_validation(
                    'Given object \'' . $request['objID'] . '\' does not have a location and can therefore not include any locally assigned components. Please set a location before.',
                    ['assigned_object' => 'Assignment of local objects not possible because of missing location.']
                );
            }
        }

        return $request;
    }
}
