<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * PortProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 */
class PortProcessor extends AbstractCategoryProcessor implements SyncModifier
{
    /**
     * Get cable property name
     *
     * @return string
     */
    protected function getCablePropertyName()
    {
        return 'cable';
    }

    /**
     * Get connector property name
     *
     * @return string
     */
    protected function getConnectorPropertyName() {
        return 'assigned_connector';
    }

    /**
     * Modify sync data
     *
     * @param array $syncData
     *
     * @return array
     */
    public function modifySyncData(array $syncData)
    {
        // Get request
        $request = $this->getRequest();

        // Skip create requests
        if ($request['option'] == 'create') {
            return $syncData;
        }

        // Property name of cable object
        $cablePropertyName = $this->getCablePropertyName();

        /**
         * The following will convert 'cable' field which will present
         * a cable connection value into a valid cable object id.
         *
         * @see API-7
         */

        // Check whether cable id was setted explicitly or is already persisted
        if (empty($request['data'][$cablePropertyName])) {
            if (!empty($syncData['properties'][$cablePropertyName][C__DATA__VALUE])) {
                try {
                    // Create cable connection dao
                    $cableConnectionDao = new \isys_cmdb_dao_cable_connection(\isys_application::instance()->container->get('database'));

                    // Get cable object id by cable connection id
                    $syncData['properties'][$cablePropertyName][C__DATA__VALUE] = $cableConnectionDao->get_cable_object_id_by_connection_id($syncData['properties'][$cablePropertyName][C__DATA__VALUE]);
                } catch (\Exception $e) {
                    // No need to interrupt api call
                }
            }
        }

        /**
         * This routine will translate "assigned_connector" which will be simply the category entry id if it is unspecified
         * to the id of the assigned connector. Thereby we can prevent losing of the assigned connector during category update
         *
         * @see API-30
         */

        // Get assigned connector property name
        $connectorPropertyName = $this->getConnectorPropertyName();

        // Check whether it is empty
        if (empty($request['data'][$connectorPropertyName]) && !empty($syncData['properties'][$connectorPropertyName][C__DATA__VALUE])) {
            try {
                // Create cable connection dao
                $cableConnectionDao = new \isys_cmdb_dao_cable_connection(\isys_application::instance()->container->get('database'));

                // Get assigned connector
                $assignedConnectorId = $cableConnectionDao->get_assigned_connector($syncData['properties'][$connectorPropertyName][C__DATA__VALUE])->get_row_value('isys_catg_connector_list__id');

                // Check whether connector is assigned
                if (!empty($assignedConnectorId)) {
                    // Set assigned connector to prevent deletion while sync routine
                    $syncData['properties'][$connectorPropertyName][C__DATA__VALUE] = $assignedConnectorId;
                }
            } catch (\Exception $e) {
                // No need to interrupt api call
            }
        }

        return $syncData;
    }
}