<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Property;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\PropertyValidation;

/**
 * Class DialogList
 *
 * @package idoit\Module\Api\Validation\Property
 */
class DialogList extends PropertyValidation
{

    /**
     * Validate value
     *
     * @return bool
     * @throws ValidationException
     */
    public function validate()
    {
        $value = $this->getValue();

        if (!is_array($value)) {
            throw new ValidationException($this->getPropertyType(), 'Property has to be an array.');
        } else if (count(array_filter($value, function ($tagValue) {
            return !is_int($tagValue) && !is_string($tagValue);
        }))) {
            throw new ValidationException($this->getPropertyType(), 'Property has to be an array which includes integer or string values only.');
        }

        return true;
    }
}
