<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation;

use idoit\Component\Property\Property;
use idoit\Module\Api\Exception\JsonRpc\InternalErrorException;
use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\Property\Virtual;

/**
 * Class Validation
 *
 * @package idoit\Module\Api\Validation
 */
abstract class PropertyValidation extends Validation
{
    /**
     * Check whether property is virtual
     *
     * @return bool
     */
    protected function isVirtual()
    {
        return $this->getPropertyDefinition()[C__PROPERTY__PROVIDES][C__PROPERTY__PROVIDES__VIRTUAL] === true;
    }

    /**
     * Check for virtual property
     *
     * @throws ValidationException
     */
    protected function virtualCheck()
    {
        // Check whether property is virtual
        if ($this->isVirtual()) {
            (new Virtual($this->getTitle(), $this->getValue(), $this->getPropertyDefinition()))->validate();
        }
    }

    /**
     * Validation constructor.
     *
     * @param string         $title
     * @param mixed          $value
     * @param array|Property $propertyDefinition
     *
     * @throws ValidationException
     */
    public function __construct($title, $value, $propertyDefinition)
    {
        if (!($propertyDefinition instanceof Property) && !is_array($propertyDefinition)) {
            throw new InternalErrorException('The provided property definition needs to be an array or instance of Property.');
        }

        parent::__construct($title, $value, $propertyDefinition);
    }
}
