# Contributing
When contributing to this repository, please first discuss the change you wish to make via issue with the owners of this repository before making a change. 

Please note we have a code of conduct, please follow it in all your interactions with the project.

This document is work in progress, we will notify you about major updates.
## Submitting Issues
### Guidelines
* Please search the existing issues first, it's likely that your issue was already reported or even fixed.
  - Go to the [repository][bitbucket], goto i-doit, click "Issues" and type any word in the top search/command bar.
* This repository is *only* for issues within the i-doit code.
* The issues in add-ons should be reported in their respective repositories: You will find them in our [Bitbucket Origanisation][bitbucket]

* Report the issue providing the following information:
  - Required:
    - i-doit Version
    - Description on reproducing the issue
    - SQL in some cases, e.g. Report Manager
    - JSON or Requests when using the API
  - Optional:
    - *Add-on & Version* e.g. API 1.9.4
    - *Component* e.g. Report Manager
* Assign the "Synetics Gruppenaccount" user

Help us to maximize the effort we can spend fixing issues and adding new features, by not reporting duplicate issues.

[template]: https://raw.githubusercontent.com/nextcloud/server/master/issue_template.md
[forum]: https://community.i-doit.com
[bitbucket]: https://bitbucket.org/synetics
## Providing Pull Requests
1. Fork the master branch as private fork and provide a pull request via feature or bug branch into our master.
2. Provide details of changes to the code as description when providing a pull request.
3. You may merge the Pull Request in once at least two people have approved your pull request and every task in the pull request is resolved. Please note that approving by yourself is not allowed.
## Contributing to Source Code
### Code Standards
- [PSR-2](https://www.php-fig.org/psr/psr-2/)
- [PSR-4](https://www.php-fig.org/psr/psr-4/)
- Name variables should always be self descriptive, e.g. instead of $db use $databaseTenant
### Tests
In order to constantly increase the quality of our software we cannot accept pull requests which submit un-tested new code. It is a must have that added code segments are unit tested. When changing existing code unit testing can be hard (aka almost impossible) as of today - in these areas refactoring while fixing a bug is encouraged to enable unit testing.

Place your tests for i-doit below src/tests/idoit and use the same directory path as for the changed/added code, e.g. src/idoit/Component/TestComponent.php would result in src/tests/idoit/src/idoit/Component/TestComponent.php.

Currently [PHPUnit 5.7.23](https://github.com/sebastianbergmann/phpunit/tree/5.7.23) is used. 
## Code of Conduct
### Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

### Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

### Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

### Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

### Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the [development team](mailto:entwickler+violations@i-doit.com). All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4/][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/

## Contributor-License-Agreement

**Thank you for your interest in the i-doit Project, which is maintained by synetics GmbH (“synetics”). In order to clarify the intellectual property license granted with contributions of software from any person or entity (the “Contributor”), synetics would like to have a Contributor License Agreement on file that has been signed by the Contributor, indicating agreement to the license terms below. This license is for your protection as a Contributor of software to i-doit and does not change your right to use your own contributions for any other purpose.**

If you have not already done so, please complete this Agreement and send it by facsimile to synetics at +49-211-69931-199, or send a photocopy by regular mail to synetics GmbH, Hildebrandtstr. 4d, 40215 Düsseldorf (Dusseldorf), Germany or by email to [contribution@i-doit.com](mailto:contribution@i-doit.com). Please read this document carefully before signing and keep the original for your records.

You and synetics hereby accept and agree to the following terms and conditions. Except for the license granted herein to synetics, you reserve all right, title, and interest in and to your Contributions.

1. **Your “Contributions”** means all of your past, present and future contributions of object code, source code and documentation to i-doit, however submitted to synetics, excluding any submissions that are conspicuously marked or otherwise designated in writing by you as “Not a Contribution.”
2. **Grant of Copyright License.** You hereby grant to synetics a perpetual, non-exclusive, irrevocable, worldwide, no-charge, royalty-free, transferable copyright license to use and exploit, publicly display, publicly perform, sublicense, execute, prepare derivative works of, reproduce and distribute (internally and externally, in object code and, if included in your Contributions, source code form) your Contributions.
3. **Grant of Patent License**. Subject to the terms and conditions of this Agreement, You hereby grant to synetics and to recipients of software distributed by synetics a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by you that are necessarily infringed by your Contribution(s) alone or by combination of your Contribution(s) with the work to which such Contribution(s) was submitted. If any entity institutes patent litigation against you or any other entity (including a cross-claim or counterclaim in a lawsuit) alleging that your Contribution, or the Work to which you have contributed, constitutes direct or contributory patent infringement, then any patent licenses granted to that entity under this Agreement for that Contribution or work shall terminate as of the date such litigation is filed.
4. You represent that you are legally entitled to grant the above license. You represent further that any employee making a Contribution on your behalf is duly authorized to do so.
5. You represent that, except as disclosed in your Contribution submission(s), each of your Contributions is your original creation. You represent that your Contribution submission(s) include complete details of any license or other restriction (including, but not limited to, related patents and trademarks) associated with any part of your Contribution(s) (including a copy of any applicable license agreement). You agree to notify synetics of any facts or circumstances of which you become aware that would make your representations in this Agreement inaccurate in any respect.
6. You are not expected to provide support for your Contributions, except to the extent you desire to provide support. You may provide support for free, for a fee, or not at all. YOUR CONTRIBUTIONS ARE PROVIDED AS-IS, WITH ALL FAULTS DEFECTS AND ERRORS, AND WITHOUT WARRANTY OF ANY KIND (EITHER EXPRESS OR IMPLIED) INCLUDING, WITHOUT LIMITATION, ANY IMPLIED WARRANTY OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY OF NON-INFRINGEMENT.
7. You agree to notify synetics of any facts or circumstances of which you become aware that would make these representations inaccurate in any respect.

## Company and Contributor Details

| Full name of your Company |  |
| --- | --- |
| Address |  |
| Country |  |
| Telephone |  |
| Facsimile |  |
| Email Address |  |
| WWW Address |  |
| Name of Company CEO |  |
| Name of Contributors |  |

## Signatures

| Signature | |
| --- | --- | 
| Print your name | |
| Date | |
