<?php

/**
 * i-doit
 *
 * API controller
 *
 * @package    i-doit
 * @subpackage API
 * @author     Benjamin Heisig <bheisig@synetics.de>, Dennis Stücken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

/**
 * API controller base class
 *
 * @deprecated This class is obsolet and exists only because
 *             constants in isys_api_controller_jsonrpc.class.php
 *             could be used in third party api models
 */
abstract class isys_api_controller extends isys_api
{

    /**
     * Constants related to used login method
     */

    /**
     * BasicAuth login method
     *
     * @var int
     */
    const LOGIN_METHOD_BASIC_AUTH = 1;

    /**
     * RpcHeader login method
     *
     * @var int
     */
    const LOGIN_METHOD_RPC_HEADER = 2;

    /**
     * Used model
     *
     * @var isys_api_model
     */
    protected $m_model;

    /**
     * API version
     *
     * @var string
     */
    protected $m_version = 'n/a';

    /**
     * Used view
     *
     * @var isys_api_view
     */
    protected $m_view;

    /**
     * Login method used for
     * retrieving a session
     *
     * @var int
     */
    protected $loginMethod;

    /**
     * Gets API version.
     *
     * @return string
     */
    public function get_version()
    {
        return $this->m_version;
    } // function

    /**
     * Gets model.
     *
     * @return isys_api_model
     */
    public function get_model()
    {
        return $this->m_model;
    } // function

    /**
     * Gets view.
     *
     * @return isys_api_view
     */
    public function get_view()
    {
        return $this->m_view;
    }

    /**
     * Get used login method
     *
     * @return int
     */
    public function getLoginMethod()
    {
        return $this->loginMethod;
    }

    /**
     * Set used login method
     *
     * @param int $loginMethod
     */
    public function setLoginMethod($loginMethod)
    {
        $this->loginMethod = $loginMethod;
    }

    /**
     * Does a session login based on the json-rpc login method.
     *
     * Login data structure: $p_login_data = array(
     *    'username' => 'user',
     *  'password' => 'pass', //md5
     *  'mandator' => 1
     * );
     *
     * @deprecated
     *
     * @param array $p_login_data
     *
     * @return bool
     */
    protected function login($p_login_data)
    {
        global $g_comp_session, $g_comp_database;

        if (!$g_comp_session->weblogin($p_login_data['username'], $p_login_data['password'], $p_login_data['mandator'], true))
        {
            $this->m_log->error('Login failed.');

            return false;
        } // if
        //
        // Set mandator database:
        $this->m_model->set_database($g_comp_database);

        return true;
    } // function

    /**
     * Does a session login based on the json-rpc login method and a defined API-Key.
     *  Also tries to authenticate over the following authentication methods:
     *      - Header based (X-RPC-Auth.Username, X-RPC-Auth.Password)
     *      - HTTP Basic Auth
     *  Tries to re-adopt an already available session by passing a valid session ID in $p_sessionID
     *
     * @param string $p_apikey
     * @param        optional string $p_sessionID
     *
     * @throws \Exception
     * @throws \isys_exception_api
     * @return bool
     */
    protected function apikey_login($p_apikey, $p_sessionID = null)
    {
        global $g_comp_session;

        if (!empty($p_apikey))
        {
            /**
             * Check wheather the requestor tries to login as a specific user
             */
            if (isys_core::header(isys_core::HTTP_RPCAuthUser, false))
            {
                $l_userdata = [
                    'username' => isys_core::header(isys_core::HTTP_RPCAuthUser, false),
                    'password' => trim(isys_core::header(isys_core::HTTP_RPCAuthPass, false))
                ];
                $this->m_log->info('Logging in with RPC Session header (User: ' . $l_userdata['username'] . ')');

                // Set login method to HEADER
                $this->setLoginMethod(self::LOGIN_METHOD_RPC_HEADER);
            }
            else if (isys_core::header(isys_core::HTTP_Authorization) && isset($_SERVER['PHP_AUTH_USER']) && isset($_SERVER['PHP_AUTH_PW']))
            {
                $this->m_log->info('Logging in with HTTP Basic Authentication (User: ' . $_SERVER['PHP_AUTH_USER'] . ')');
                $l_userdata = [
                    'username' => $_SERVER['PHP_AUTH_USER'],
                    'password' => trim($_SERVER['PHP_AUTH_PW'])
                ];

                // Set login method to BASIC AUTH
                $this->setLoginMethod(self::LOGIN_METHOD_BASIC_AUTH);
            }
            else
            {
                $l_userdata = null;
            } // if

            if ($g_comp_session->apikey_login($p_apikey, $l_userdata, $p_sessionID))
            {
                return true;
            } // if

            if ($l_userdata)
            {
                // Log failed APi login:
                isys_application::instance()->container->get('logger')->warning(
                    'APi Authentication failed for user ' . $l_userdata['username'],
                    [
                        'api-key' => $p_apikey,
                        'user'    => $l_userdata['username']
                    ]
                );

                throw new isys_exception_api('Either your username or password is invalid.', isys_api_controller_jsonrpc::ERR_Auth);
            }
            else
            {
                // Log failed APi login:
                isys_application::instance()->container->get('logger')->warning(
                    'APi Authentication failed for key ' . $p_apikey,
                    ['api-key' => $p_apikey]
                );

                throw new isys_exception_api('Your API-Key \'' . $p_apikey . '\' is invalid.', isys_api_controller_jsonrpc::ERR_Auth);
            }

        } // if

        return false;
    } // function

    /**
     * Logout current user
     *
     * @return boolean
     */
    public function logout()
    {
        global $g_comp_session;

        // Check whether user has an session
        if ($g_comp_session->is_logged_in()) {
            // Logging out user
            return $g_comp_session->logout();
        }

        return false;
    }
} // class
