<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Request;

/**
 * Class AbstractRequest
 *
 * @package idoit\Module\Api\Request
 */
abstract class AbstractRequest
{
    /**
     * Request related data
     *
     * @var array
     */
    protected $data = [];

    /**
     * Is request a notification
     *
     * @return mixed
     */
    public abstract function isNotification();

    /**
     * Validate request
     *
     * @return bool
     */
    public abstract function validate();

    /**
     * Get request data
     *
     * @return array
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * AbstractRequest constructor.
     *
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->data = $data;
    }
}
