<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api;

/**
 * Class SearchIndexRegister
 *
 * @package idoit\Module\Api
 */
class SearchIndexRegister
{
    /**
     * Registerd changes
     *
     * @var array
     */
    private static $register = [];

    /**
     * Register changed category for object
     *
     * @param       $objectId
     * @param array $categoryConstants
     */
    public static function register($objectId, array $categoryConstants)
    {
        foreach ($categoryConstants as $categoryConstant) {
            self::$register[$objectId][$categoryConstant] = true;
        }
    }

    /**
     * Get object oriented register
     *
     * @return array
     */
    public static function getObjectOrientedRegister()
    {
        return self::$register;
    }

    /**
     * Get category oriented register
     *
     * @return array
     */
    public static function getCategoryOrientedRegister()
    {
        $categoryRegister = [];

        foreach (self::$register as $objectId => $categoryConstants) {
            foreach ($categoryConstants as $categoryConstant => $tp) {
                $categoryRegister[$categoryConstant][$objectId] = true;
            }
        }

        return $categoryRegister;
    }
}