<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     API
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_api_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     */
    public static function init($className)
    {
        // Path to root directory of api module
        $moduleRootDirectory = '/src/classes/modules/api/';

        $classMap = [
            'isys_api' => 'isys_api.class.php',
            'isys_api_controller' => 'controller/isys_api_controller.class.php',
            'isys_api_controller_jsonrpc' => 'controller/isys_api_controller_jsonrpc.class.php',
            'isys_api_model' => 'model/isys_api_model.class.php',
            'isys_api_model_cmdb' => 'model/isys_api_model_cmdb.class.php',
            'isys_api_model_cmdb_categories' => 'model/cmdb/isys_api_model_cmdb_categories.class.php',
            'isys_api_model_cmdb_category' => 'model/cmdb/isys_api_model_cmdb_category.class.php',
            'isys_api_model_cmdb_category_info' => 'model/cmdb/isys_api_model_cmdb_category_info.class.php',
            'isys_api_model_cmdb_condition' => 'model/cmdb/isys_api_model_cmdb_condition.class.php',
            'isys_api_model_cmdb_contact' => 'model/cmdb/isys_api_model_cmdb_contact.class.php',
            'isys_api_model_cmdb_dialog' => 'model/cmdb/isys_api_model_cmdb_dialog.class.php',
            'isys_api_model_cmdb_filter' => 'model/cmdb/isys_api_model_cmdb_filter.class.php',
            'isys_api_model_cmdb_impact' => 'model/cmdb/isys_api_model_cmdb_impact.class.php',
            'isys_api_model_cmdb_location_tree' => 'model/cmdb/isys_api_model_cmdb_location_tree.class.php',
            'isys_api_model_cmdb_logbook' => 'model/cmdb/isys_api_model_cmdb_logbook.class.php',
            'isys_api_model_cmdb_object' => 'model/cmdb/isys_api_model_cmdb_object.class.php',
            'isys_api_model_cmdb_objects' => 'model/cmdb/isys_api_model_cmdb_objects.class.php',
            'isys_api_model_cmdb_objects_by_relation' => 'model/cmdb/isys_api_model_cmdb_objects_by_relation.class.php',
            'isys_api_model_cmdb_object_types' => 'model/cmdb/isys_api_model_cmdb_object_types.class.php',
            'isys_api_model_cmdb_object_type_categories' => 'model/cmdb/isys_api_model_cmdb_object_type_categories.class.php',
            'isys_api_model_cmdb_object_type_groups' => 'model/cmdb/isys_api_model_cmdb_object_type_groups.class.php',
            'isys_api_model_cmdb_reports' => 'model/cmdb/isys_api_model_cmdb_reports.class.php',
            'isys_api_model_cmdb_status' => 'model/cmdb/isys_api_model_cmdb_status.class.php',
            'isys_api_model_cmdb_workstation_components' => 'model/cmdb/isys_api_model_cmdb_workstation_components.class.php',
            'isys_api_model_console' => 'model/isys_api_model_console.class.php',
            'isys_api_model_console_auth' => 'model/console/isys_api_model_console_auth.class.php',
            'isys_api_model_console_commands' => 'model/console/isys_api_model_console_commands.class.php',
            'isys_api_model_console_document' => 'model/console/isys_api_model_console_document.class.php',
            'isys_api_model_console_dynamicgroups' => 'model/console/isys_api_model_console_dynamicgroups.class.php',
            'isys_api_model_console_import' => 'model/console/isys_api_model_console_import.class.php',
            'isys_api_model_console_ldap' => 'model/console/isys_api_model_console_ldap.class.php',
            'isys_api_model_console_logbook' => 'model/console/isys_api_model_console_logbook.class.php',
            'isys_api_model_console_notifications' => 'model/console/isys_api_model_console_notifications.class.php',
            'isys_api_model_console_report' => 'model/console/isys_api_model_console_report.class.php',
            'isys_api_model_console_search' => 'model/console/isys_api_model_console_search.class.php',
            'isys_api_model_console_settings' => 'model/console/isys_api_model_console_settings.class.php',
            'isys_api_model_console_system' => 'model/console/isys_api_model_console_system.class.php',
            'isys_api_model_idoit' => 'model/isys_api_model_idoit.class.php',
            'isys_api_model_idoit_addons' => 'model/idoit/isys_api_model_idoit_addons.class.php',
            'isys_api_model_idoit_constants' => 'model/idoit/isys_api_model_idoit_constants.class.php',
            'isys_api_model_idoit_license' => 'model/idoit/isys_api_model_idoit_license.class.php',
            'isys_api_model_idoit_login' => 'model/idoit/isys_api_model_idoit_login.class.php',
            'isys_api_model_idoit_logout' => 'model/idoit/isys_api_model_idoit_logout.class.php',
            'isys_api_model_idoit_search' => 'model/idoit/isys_api_model_idoit_search.class.php',
            'isys_api_model_idoit_version' => 'model/idoit/isys_api_model_idoit_version.class.php',
            'isys_api_model_interface' => 'model/isys_api_model_interface.class.php',
            'isys_api_view' => 'view/isys_api_view.class.php',
            'isys_api_view_json' => 'view/isys_api_view_json.class.php',
        ];

        // Check whether class is registered in class list
        if (isset($classMap[$className]) && parent::include_file($moduleRootDirectory . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $moduleRootDirectory . $classMap[$className]);

            return true;
        }

        return false;
    }
}
