<?php

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\RequestModifier;

/**
 * ConnectorProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 * @author     Selcuk Kekec <skekec@i-doit.com>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class ConnectorProcessor extends PortProcessor implements RequestModifier
{
    /**
     * Get cable property name
     *
     * @return string
     */
    protected function getCablePropertyName()
    {
        return 'cable_connection';
    }

    /**
     * Modify api request.
     *
     * @param array $request
     *
     * @return array
     */
    public function modifyRequest(array $request)
    {
        if (!isset($request['data']['fiber_wave_lengths']) || empty($request['data']['fiber_wave_lengths'])) {
            $request['data']['fiber_wave_lengths'] = null;
        }

        return $request;
    }
}
