<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Leonard Fischer <lfischer@i-doit.com>
 * @version    1.11
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * Class VirtualHostProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class VirtualHostProcessor extends AbstractCategoryProcessor implements SyncModifier
{
    /**
     * Modify sync data.
     *
     * @param array $syncData
     *
     * @return array
     * @throws \isys_exception_database
     */
    public function modifySyncData(array $syncData)
    {
        // Get request information.
        $request = $this->getRequest();
        $virtualHostDao = $this->getDao();

        // Skip non-save requests.
        if (!in_array($request['option'], ['save', 'update'], true)) {
            return $syncData;
        }

        if (isset($syncData['data_id']) && is_numeric($syncData['data_id'])) {
            $virtualHostData = $virtualHostDao
                ->get_data($syncData['data_id'])
                ->get_row();

            /*
             * @see  API-228  If no license_server was passed, the sync data needs to remain empty.
             * The problem here is that the ID of isys_connection gets filled in, but the sync method will use this as object ID.
             *
             * By the way: we can't use isset() here, since the value might be explicitly NULL to remove the reference.
             */
            if (!array_key_exists('license_server', $request['data'])) {
                // In this case the parameter was never set.
                $syncData['properties']['license_server']['value'] = $virtualHostData['licence_server_connection__object'];
            }

            // @see  API-228  Same as above
            if (!array_key_exists('administration_service', $request['data'])) {
                // In this case the parameter was never set.
                $syncData['properties']['administration_service']['value'] = $virtualHostData['administration_service_connection__object'];
            }
        }

        return $syncData;
    }
}