<?php

/**
 * i-doit
 *
 * API model
 *
 * @package    i-doit
 * @subpackage API
 * @author     Van Quyen Hoang <qhoang@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_cmdb_contact extends isys_api_model_cmdb implements isys_api_model_interface
{

    /**
     * Data formatting used in format methods.
     *
     * @var array
     */
    protected $mapping = [
        'isys_obj__id'                => 'id',
        'isys_obj__title'             => 'title',
        'isys_obj__sysid'             => 'sysid',
        'isys_obj__isys_obj_type__id' => 'type',
        'isys_obj_type__title'        => ['_L', 'type_title']
    ];

    /**
     * Possible options and their parameters.
     *
     * @var array
     */
    protected $m_options = [
        'read' => [
            'email' => [
                'type'     => 'string',
                'optional' => true
            ],
            'id'    => [
                'type'     => 'int',
                'optional' => true
            ]
        ]
    ];

    /**
     * Validation.
     *
     * @var array
     */
    protected $m_validation = [];

    /**
     * Fetches information of the person.
     *
     * @param array $p_params
     *
     * @return bool
     * @throws isys_exception_api
     * @author Van Quyen Hoang <qhoang@synetics.de>
     */
    public function read($p_params)
    {
        // One or more filters have to be set:
        $l_filter = [];

        /**
         * @deprecated still handle deprecated call parameter
         */
        if (isset($p_params['call']))
        {
            $l_method = $p_params['call'];
        }
        else
        {
            if (!isset($p_params['method']))
            {
                throw new isys_exception_api('You need to specify the parameter "method"');
            }

            $l_method = $p_params['method'];
        }

        if (isset($p_params['filter']) && is_array($p_params['filter']))
        {
            $l_filter = $p_params['filter'];

            if (isset($l_filter['id']))
            {
                $l_filter['id'] = (int) $l_filter['id'];
            }
        }

        if (count($l_filter) === 0)
        {
            throw new isys_exception_api('Invalid parameter. At least one filter is required.');
        }

        if (method_exists($this, $l_method))
        {
            return $this->$l_method($l_filter);
        }

        return false;
    }

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @return isys_api_model_cmdb Returns itself.
     * @throws isys_exception_api
     * @internal param string $p_method Data method
     */
    public function create($p_params)
    {
        throw new isys_exception_api('Creating is not possible here.');
    }

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @return isys_api_model_cmdb Returns itself.
     * @throws isys_exception_api
     * @internal param string $p_method Data method
     */
    public function delete($p_params)
    {
        throw new isys_exception_api('Deleting is not possible here.');
    }

    /**
     * @param array $p_params Parameters (depends on data method)
     *
     * @throws isys_exception_api
     * @return isys_api_model_cmdb Returns itself.
     */
    public function update($p_params)
    {
        throw new isys_exception_api('Updating is not possible here.');
    }

    /**
     * Retrieves all assigned objects by contact
     *
     * @param array $filter
     *
     * @return array
     */
    private function assigned_objects_by_contact($filter)
    {
        $return     = [];
        $daoContact = new isys_cmdb_dao_category_g_contact($this->m_db);

        if (isset($filter['email']))
        {
            $this->m_log->info('Retrieve object(s) by email address "' . $filter['email'] . '".');
            $assignedObjectsResult = $daoContact->get_assigned_objects_by_contact(null, $filter['email']);
        }
        else if (isset($filter['id']))
        {
            $this->m_log->info('Retrieve object(s) by ID "' . $filter['id'] . '".');
            $assignedObjectsResult = $daoContact->get_assigned_objects_by_contact($filter['id']);
        }

        if (isset($assignedObjectsResult))
        {
            // Iterate through found persons.
            while ($row = $assignedObjectsResult->get_row())
            {
                if ($this->useAuth && !isys_auth_cmdb_categories::instance()->has_rights_in_obj_and_category(isys_auth::VIEW, $row['isys_obj__id'], 'C__CATG__CONTACT'))
                {
                    continue;
                }

                $return[$row['isys_obj__id']]            = $this->format_by_mapping($this->mapping, $row);
                $return[$row['isys_obj__id']]['primary'] = ($row['isys_catg_contact_list__primary_contact'] > 0) ? _L('LC__UNIVERSAL__YES') : _L('LC__UNIVERSAL__NO');
                $return[$row['isys_obj__id']]['role']    = _L($row['isys_contact_tag__title']);
            }
        }

        return $return;
    }

    /**
     * Constructor
     */
    public function __construct(isys_cmdb_dao $p_dao)
    {
        $this->m_dao = $p_dao;
        parent::__construct();
    }
}
