<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Leonard Fischer <lfischer@i-doit.com>
 * @version    1.11
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Model\Cmdb\Category\Processor;

use idoit\Module\Api\Model\Cmdb\Category\Processor\Provider\SyncModifier;

/**
 * Class GeneralProcessor
 *
 * @package idoit\Module\Api\Model\Cmdb\Category\Processor
 */
class GeneralProcessor extends AbstractCategoryProcessor implements SyncModifier
{
    /**
     * Modify sync data.
     *
     * @param array $syncData
     *
     * @return array
     * @throws \isys_exception_database
     */
    public function modifySyncData(array $syncData)
    {
        // Get request information.
        $request = $this->getRequest();
        $generalDao = $this->getDao();

        // Skip non-save requests.
        if (!in_array($request['option'], ['save', 'update'], true)) {
            return $syncData;
        }

        // @see  API-224  We need to deal with possible wrong references, due to property field definition.
        if ((!isset($syncData['properties']['tag']['value']) || !is_array($syncData['properties']['tag']['value'])) && $generalDao instanceof \isys_cmdb_dao_category_g_global) {
            // Read the tags of the given object.
            $assignedTagIds = $generalDao->get_assigned_tag($request['object'], true);

            if (count($assignedTagIds) === 0) {
                return $syncData;
            }

            // Re-set the tag IDs.
            $syncData['properties']['tag']['value'] = array_map('intval', $assignedTagIds);
        }

        return $syncData;
    }
}